/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.templating;

import com.google.gson.JsonObject;
import net.lucent.easygui.interfaces.ContainerRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import org.jetbrains.annotations.NotNull;

public interface IRenderableDeserializer {
    @NotNull
    public IRenderableDeserializer createInstance();

    public ContainerRenderable getRenderable();

    public Double call(String[] var1);

    default public Double getX() {
        return this.getRenderable().getX();
    }

    default public Double getGlobalScaledX() {
        return this.getRenderable().getGlobalScaledX();
    }

    default public Double getWidth() {
        return this.getRenderable().getWidth();
    }

    default public Double getScaledWidth() {
        return this.getRenderable().getScaledWidth();
    }

    default public Double getY() {
        return this.getRenderable().getY();
    }

    default public Double getGlobalScaledY() {
        return this.getRenderable().getGlobalScaledY();
    }

    default public Double getHeight() {
        return this.getRenderable().getHeight();
    }

    default public Double getScaledHeight() {
        return this.getRenderable().getScaledHeight();
    }

    default public String getOrDefault(JsonObject object, String key, String defaultValue) {
        if (object.get(key) == null) {
            return defaultValue;
        }
        return object.get(key).getAsString();
    }

    default public Boolean getOrDefault(JsonObject object, String key, Boolean defaultValue) {
        if (object.get(key) == null) {
            return defaultValue;
        }
        return object.get(key).getAsBoolean();
    }

    default public Integer getOrDefault(JsonObject object, String key, Integer defaultValue) {
        if (object.get(key) == null) {
            return defaultValue;
        }
        return object.get(key).getAsInt();
    }

    default public Double getOrDefault(JsonObject object, String key, Double defaultValue) {
        if (object.get(key) == null) {
            return defaultValue;
        }
        return object.get(key).getAsDouble();
    }

    default public Object[] getList(JsonObject object, String key) {
        System.out.println(object.get(key));
        System.out.println(object.getAsJsonArray(key));
        if (object.getAsJsonArray(key) == null) {
            return new Object[0];
        }
        return object.getAsJsonArray(key).asList().toArray();
    }

    public IRenderableDeserializer getParent();

    public void buildRenderable(IEasyGuiScreen var1, IRenderableDeserializer var2, JsonObject var3);

    public void buildChildren(IEasyGuiScreen var1, JsonObject var2);

    default public ContainerRenderable build(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
        this.buildRenderable(screen, parent, obj);
        this.buildChildren(screen, obj);
        return this.getRenderable();
    }
}

