/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.templating.deserializers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Supplier;
import net.lucent.easygui.EasyGui;
import net.lucent.easygui.elements.BaseRenderable;
import net.lucent.easygui.interfaces.ContainerRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.ITextureData;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.lucent.easygui.templating.actions.Action;
import net.lucent.easygui.templating.actions.IAction;
import net.lucent.easygui.templating.parsers.RPNParser;
import net.lucent.easygui.templating.parsers.ShuntingYardExprParser;
import net.lucent.easygui.templating.registry.EasyGuiRegistries;
import net.lucent.easygui.util.textures.TextureDataSubSection;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BaseDeserializer
implements IRenderableDeserializer {
    private BaseRenderable renderable;
    private IRenderableDeserializer parent;
    private final HashMap<String, Supplier<Double>> dataSuppliers = new HashMap<String, Supplier<Double>>(){
        {
            this.put("x", BaseDeserializer.this::getX);
            this.put("y", BaseDeserializer.this::getY);
            this.put("globalX", BaseDeserializer.this::getGlobalScaledX);
            this.put("globalY", BaseDeserializer.this::getGlobalScaledY);
            this.put("width", BaseDeserializer.this::getWidth);
            this.put("height", BaseDeserializer.this::getHeight);
            this.put("scaledWidth", BaseDeserializer.this::getScaledWidth);
            this.put("scaledHeight", BaseDeserializer.this::getScaledHeight);
        }
    };
    public final Supplier<? extends BaseRenderable> supplier;

    public BaseDeserializer(Supplier<? extends BaseRenderable> supplier) {
        this.supplier = supplier;
    }

    @Override
    @NotNull
    public IRenderableDeserializer createInstance() {
        return new BaseDeserializer(this.supplier);
    }

    @Override
    public BaseRenderable getRenderable() {
        return this.renderable;
    }

    @Override
    public Double call(String[] functionName) {
        System.out.println("called");
        System.out.println(Arrays.toString(functionName));
        if (functionName.length == 0) {
            return null;
        }
        if (functionName[0].equals("parent")) {
            return this.getParent().call((String[])Arrays.stream(functionName, 1, functionName.length).toArray(String[]::new));
        }
        return this.dataSuppliers.get(functionName[0]).get();
    }

    @Override
    public IRenderableDeserializer getParent() {
        return this.parent;
    }

    public void parseWidth(String expr) {
        this.renderable.setWidth(RPNParser.parse(ShuntingYardExprParser.parseInput(expr), this).intValue());
    }

    public void parseHeight(String expr) {
        this.renderable.setHeight(RPNParser.parse(ShuntingYardExprParser.parseInput(expr), this).intValue());
    }

    public void parseX(String expr) {
        this.renderable.setX(RPNParser.parse(ShuntingYardExprParser.parseInput(expr), this).intValue());
    }

    public void parseY(String expr) {
        this.renderable.setY(RPNParser.parse(ShuntingYardExprParser.parseInput(expr), this).intValue());
    }

    public void parseRotation(String expr1, String expr2, String expr3) {
        double x = RPNParser.parse(ShuntingYardExprParser.parseInput(expr1), this);
        double y = RPNParser.parse(ShuntingYardExprParser.parseInput(expr2), this);
        double z = RPNParser.parse(ShuntingYardExprParser.parseInput(expr3), this);
        this.renderable.setRotation(x, y, z);
    }

    public Action parseAction(String key, JsonObject obj) {
        System.out.println("parsing action");
        JsonObject functionObj = obj.getAsJsonObject(key);
        if (functionObj == null) {
            return null;
        }
        String function = this.getOrDefault(functionObj, "function", (String)null);
        Object[] args = this.getList(functionObj, "args");
        System.out.println(args);
        if (function != null) {
            System.out.println(function);
            String functionName = function.split(":")[1];
            String functionModId = function.split(":")[0];
            return new Action((IAction)EasyGuiRegistries.Actions.ACTION_REGISTRY.get(ResourceLocation.fromNamespaceAndPath((String)functionModId, (String)functionName)), args);
        }
        return null;
    }

    public void throwMissingField(String msg) {
        throw new RuntimeException("Parsing Error: " + msg);
    }

    public ITextureData parseTexture(String key, JsonObject object) {
        if (object.getAsJsonObject(key) == null) {
            return null;
        }
        JsonObject textureObj = object.getAsJsonObject(key);
        String resourceLocation = textureObj.get("file").getAsString();
        Integer textureWidth = this.getOrDefault(textureObj, "texture_width", (Integer)null);
        Integer textureHeight = this.getOrDefault(textureObj, "texture_height", (Integer)null);
        if (textureWidth == null) {
            this.throwMissingField("expected field texture_width");
        }
        if (textureHeight == null) {
            this.throwMissingField("expected field texture_height");
        }
        Integer width = this.getOrDefault(textureObj, "width", textureWidth);
        Integer height = this.getOrDefault(textureObj, "height", textureHeight);
        Integer u = this.getOrDefault(textureObj, "u", 0);
        Integer v = this.getOrDefault(textureObj, "v", 0);
        return new TextureDataSubSection(ResourceLocation.fromNamespaceAndPath((String)resourceLocation.split(":")[0], (String)resourceLocation.split(":")[1]), textureWidth, textureHeight, u, v, width, height);
    }

    public Component parseComponent(String key, JsonObject obj) {
        if (obj.getAsJsonObject(key) != null) {
            JsonObject textObject = obj.getAsJsonObject(key);
            System.out.println(textObject);
            String type = textObject.get("type").getAsString();
            String text = textObject.get("data").getAsString();
            System.out.println(type);
            System.out.println(text);
            if (type == null) {
                this.throwMissingField("missing field Type for label text");
            }
            if (text == null) {
                this.throwMissingField("missing data field for label text");
            }
            if (type.equals("literal")) {
                return Component.literal((String)text);
            }
            if (type.equals("key")) {
                return Component.translatable((String)text);
            }
            if (type.equals("key_bind")) {
                return Component.keybind((String)text);
            }
        }
        return null;
    }

    @Override
    public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
        this.parent = parent;
        this.renderable = this.supplier.get();
        System.out.println("parsing renderable of type: " + String.valueOf(this.renderable));
        this.renderable.setScreen(screen);
        String sX = this.getOrDefault(obj, "x", "0");
        String sY = this.getOrDefault(obj, "y", "0");
        String sWidth = this.getOrDefault(obj, "width", "0");
        String sHeight = this.getOrDefault(obj, "height", "0");
        System.out.println("got x y width and height");
        Boolean cull = this.getOrDefault(obj, "cull", false);
        Boolean visible = this.getOrDefault(obj, "visible", true);
        Boolean active = this.getOrDefault(obj, "active", true);
        Integer cullBorder = this.getOrDefault(obj, "cull_border", 0);
        Double customScaling = this.getOrDefault(obj, "scale", 1.0);
        Boolean useCustomScaling = this.getOrDefault(obj, "use_scale", true);
        Boolean sticky = this.getOrDefault(obj, "sticky", false);
        System.out.println("got a bunch of random stuff");
        this.getRenderable().setCustomScale(customScaling);
        this.getRenderable().setSticky(sticky);
        this.getRenderable().setActive(active);
        this.getRenderable().setCull(cull);
        this.getRenderable().setActive(active);
        this.getRenderable().setVisible(visible);
        this.getRenderable().setCullBorder(cullBorder);
        this.getRenderable().useCustomScaling = useCustomScaling;
        String sRotationX = "0";
        String sRotationY = "0";
        String sRotationZ = "0";
        if (obj.getAsJsonObject("rotation") != null) {
            JsonObject rotationObj = obj.getAsJsonObject("rotation");
            sRotationX = this.getOrDefault(rotationObj, "x", "0");
            sRotationY = this.getOrDefault(rotationObj, "y", "0");
            sRotationZ = this.getOrDefault(rotationObj, "z", "0");
        }
        System.out.println("got rotation");
        String id = this.getOrDefault(obj, "id", (String)null);
        String classes = this.getOrDefault(obj, "class", (String)null);
        if (classes != null) {
            for (String item : classes.trim().split("\\s+")) {
                this.getRenderable().addClass(item.trim());
            }
        }
        this.getRenderable().setID(id);
        System.out.println("got class and id");
        if (obj.getAsJsonObject("on_tick") != null) {
            this.renderable.setTickAction(this.parseAction("on_tick", obj));
        }
        if (obj.getAsJsonObject("on_resize") != null) {
            this.renderable.setTickAction(this.parseAction("on_resize", obj));
        }
        if (obj.getAsJsonObject("on_scale_changed") != null) {
            this.renderable.setTickAction(this.parseAction("on_scale_changed", obj));
        }
        System.out.println("got tick");
        this.parseRotation(sRotationX, sRotationY, sRotationZ);
        this.parseWidth(sWidth);
        this.parseHeight(sHeight);
        this.parseX(sX);
        this.parseY(sY);
        System.out.println("parsed rotation data properly");
        System.out.println("parsing " + id);
        System.out.println("x : " + this.renderable.getX());
        System.out.println("y: " + this.renderable.getY());
        System.out.println("scaledWidth : " + this.renderable.getScaledWidth());
    }

    @Override
    public void buildChildren(IEasyGuiScreen screen, JsonObject object) {
        if (object.getAsJsonArray("children") == null) {
            return;
        }
        for (JsonElement childElement : object.getAsJsonArray("children")) {
            if (childElement.getAsJsonObject() == null) {
                EasyGui.LOGGER.error("unexpected value expected view object");
                return;
            }
            JsonObject childObj = childElement.getAsJsonObject();
            if (childObj.get("type") == null) continue;
            String[] args = childObj.get("type").getAsString().split(":");
            IRenderableDeserializer deserializer = (IRenderableDeserializer)((Registry)EasyGuiRegistries.Deserializers.DESERIALIZERS.getRegistry().get()).get(ResourceLocation.fromNamespaceAndPath((String)args[0], (String)args[1]));
            if (deserializer == null) continue;
            deserializer = deserializer.createInstance();
            ContainerRenderable renderable = deserializer.build(screen, this, childElement.getAsJsonObject());
            this.getRenderable().addChild(renderable);
        }
    }
}

