/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.templating.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ShuntingYardExprParser {
    public static final Set<String> digits = Set.of("1", "2", "3", "4", "5", "6", "7", "8", "9", "0");
    public static final HashMap<String, Integer> operandPriority = new HashMap<String, Integer>(){
        {
            this.put("+", 2);
            this.put("-", 2);
            this.put("*", 3);
            this.put("/", 3);
            this.put("^", 4);
            this.put("(", 1);
        }
    };
    public static final Set<String> leftAssociative = Set.of("+", "-", "*", "/");

    public static List<Token> parseInput(String input) {
        System.out.println("shunting yard");
        ArrayList<String> operandStack = new ArrayList<String>();
        ArrayList<Token> output = new ArrayList<Token>();
        input = input.replaceAll("\\s", "");
        ArrayList<String> inputList = new ArrayList<String>();
        char[] cArray = input.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character ch = Character.valueOf(cArray[i]);
            inputList.add(ch.toString());
        }
        Iterator iterator = inputList.iterator();
        while (iterator.hasNext()) {
            char chC;
            String ch = (String)iterator.next();
            if (digits.contains(ch)) {
                StringBuilder builder = new StringBuilder();
                do {
                    builder.append(ch);
                } while (iterator.hasNext() && digits.contains(ch = (String)iterator.next()));
                output.add(new Value(builder.toString()));
            }
            if (Character.isAlphabetic(chC = ch.toCharArray()[0]) || ch.equals(".")) {
                StringBuilder builder = new StringBuilder();
                do {
                    builder.append(ch);
                } while (iterator.hasNext() && (Character.isAlphabetic(chC = (ch = (String)iterator.next()).toCharArray()[0]) || ch.equals(".")));
                output.add(new Variable(builder.toString()));
            }
            if (operandPriority.containsKey(ch)) {
                while (!operandStack.isEmpty() && operandPriority.get(operandStack.getLast()) >= operandPriority.get(ch) && leftAssociative.contains(ch)) {
                    output.add(new Operator((String)operandStack.removeLast()));
                }
                operandStack.add(ch);
            }
            if (!Objects.equals(ch, ")")) continue;
            while (!operandStack.isEmpty() && !Objects.equals(operandStack.getLast(), "(")) {
                output.add(new Operator((String)operandStack.removeLast()));
            }
            if (operandStack.isEmpty()) continue;
            operandStack.removeLast();
        }
        if (!operandStack.isEmpty()) {
            for (String op : operandStack.reversed()) {
                output.add(new Operator(op));
            }
        }
        return output;
    }

    public record Value(String value) implements Token
    {
    }

    public record Variable(String value) implements Token
    {
    }

    public record Operator(String value) implements Token
    {
    }

    public record Function(String value) implements Token
    {
    }

    public static interface Token {
    }
}

