/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.util.math;

import org.joml.Vector3f;

public class BoundChecker {
    public static boolean containsRec(Rec2d rec1, Rec2d rec2) {
        boolean p1 = rec1.p1.x <= rec2.p1.x && rec1.p1.y <= rec2.p1.y;
        boolean p2 = rec1.p2.x >= rec2.p2.x && rec1.p2.y <= rec2.p2.y;
        boolean p3 = rec1.p3.x >= rec2.p3.x && rec1.p3.y >= rec2.p3.y;
        boolean p4 = rec1.p4.x <= rec2.p4.x && rec1.p4.y >= rec2.p4.y;
        return p1 && p2 && p3 && p4;
    }

    public static boolean containsPoint(Rec2d rec, Vec2 checkpoint) {
        return BoundChecker.containsPoint(rec.p1, rec.p2, rec.p3, rec.p4, checkpoint);
    }

    public static boolean containsPoint(Vec2 p1, Vec2 p2, Vec2 p3, Vec2 p4, Vec2 checkPoint) {
        return BoundChecker.containsPoint(p1, p2, p3, checkPoint) || BoundChecker.containsPoint(p3, p4, p1, checkPoint);
    }

    public static double getArea(Vec2 p1, Vec2 p2, Vec2 p3) {
        return Math.abs(0.5 * (double)(p1.x * (p2.y - p3.y) + p2.x * (p3.y - p1.y) + p3.x * (p1.y - p2.y)));
    }

    public static boolean containsPoint(Vec2 p1, Vec2 p2, Vec2 p3, Vec2 checkPoint) {
        double a3;
        double a2;
        double targetArea = BoundChecker.getArea(p1, p2, p3);
        double a1 = BoundChecker.getArea(p1, p2, checkPoint);
        return a1 + (a2 = BoundChecker.getArea(p1, p3, checkPoint)) + (a3 = BoundChecker.getArea(p2, p3, checkPoint)) <= targetArea;
    }

    public static class Rec2d {
        public Vec2 p1;
        public Vec2 p2;
        public Vec2 p3;
        public Vec2 p4;

        public Rec2d(Vec2 p1, Vec2 p2, Vec2 p3, Vec2 p4) {
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
        }

        public void print() {
            System.out.println("Rec2d(");
            System.out.println("Vec2(" + this.p1.x + "," + this.p1.y + "),");
            System.out.println("Vec2(" + this.p2.x + "," + this.p2.y + "),");
            System.out.println("Vec2(" + this.p3.x + "," + this.p3.y + "),");
            System.out.println("Vec2(" + this.p4.x + "," + this.p4.y + "))");
        }
    }

    public static class Vec2 {
        public int x;
        public int y;

        public Vec2(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Vec2(Vector3f v) {
            this((int)v.x(), (int)v.y());
        }
    }
}

