/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.util.textures;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.lucent.easygui.interfaces.ITextureData;
import net.minecraft.client.gui.GuiGraphics;

public class AnimatedTexture {
    public List<Pair<ITextureData, Integer>> frameData = new ArrayList<Pair<ITextureData, Integer>>();
    private int currentFrame;
    private double totalTimeElapsed;
    private double timeElapsed;
    private double timeSinceLastTick;
    private boolean paused = false;
    private final boolean loop;

    private AnimatedTexture(List<Pair<ITextureData, Integer>> frameData, boolean loop) {
        this.frameData = frameData;
        this.loop = loop;
    }

    public boolean isFinished() {
        if (this.loop) {
            return false;
        }
        return this.currentFrame >= this.frameData.size();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public void setCurrentFrame(int frame) {
        this.currentFrame = frame;
    }

    public ITextureData getFrame(int frame) {
        return (ITextureData)this.frameData.get(frame % this.frameData.size()).getFirst();
    }

    public void render(GuiGraphics guiGraphics, int x, int y, double partialTick) {
        if (this.isFinished()) {
            return;
        }
        if (this.isPaused()) {
            return;
        }
        this.timeSinceLastTick += partialTick;
        if (this.timeSinceLastTick >= 1.0) {
            this.timeSinceLastTick = 0.0;
            this.totalTimeElapsed += 1.0;
            this.timeElapsed += 1.0;
        }
        this.getFrame(this.getCurrentFrame()).renderTexture(guiGraphics, x, y);
        if (this.timeElapsed == (double)((Integer)this.frameData.get(this.currentFrame).getSecond()).intValue()) {
            this.timeElapsed = 0.0;
            this.setCurrentFrame(this.getCurrentFrame() + 1);
        }
    }

    public static class Builder {
        private static final List<Pair<ITextureData, Integer>> frameData = new ArrayList<Pair<ITextureData, Integer>>();
        private static boolean loop = false;

        public Builder addFrame(ITextureData frame, int frameTime) {
            frameData.add((Pair<ITextureData, Integer>)new Pair((Object)frame, (Object)frameTime));
            return this;
        }

        public Builder setLooping(boolean looping) {
            loop = looping;
            return this;
        }

        public AnimatedTexture build() {
            return new AnimatedTexture(frameData, loop);
        }
    }
}

