/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements;

import java.util.ArrayList;
import java.util.List;
import net.lucent.easygui.interfaces.ContainerRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Quaternionf;

public abstract class BaseRenderable
implements ContainerRenderable {
    private int x;
    private int y;
    public boolean active = true;
    public boolean visible = true;
    public boolean focused = false;
    public boolean useCustomScaling = true;
    private double customScale = 1.0;
    public double xRotation = 0.0;
    public double yRotation = 0.0;
    public double zRotation = 0.0;
    public IEasyGuiScreen screen;
    public ContainerRenderable parent;
    public List<ContainerRenderable> children = new ArrayList<ContainerRenderable>();

    public BaseRenderable(IEasyGuiScreen screen) {
        this.screen = screen;
        screen.register(this);
    }

    @Override
    public void setRotation(double x, double y, double z) {
        this.xRotation = x;
        this.yRotation = y;
        this.zRotation = z;
    }

    @Override
    public double getRotationX() {
        return this.xRotation;
    }

    @Override
    public double getRotationY() {
        return this.yRotation;
    }

    @Override
    public double getRotationZ() {
        return this.zRotation;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public double getGlobalScaledX() {
        if (this.parent != null) {
            return (double)this.getX() * this.parent.getTotalScaleFactorX() + this.parent.getGlobalScaledX();
        }
        return this.getX();
    }

    @Override
    public double getGlobalScaledY() {
        if (this.parent != null) {
            return (double)this.getY() * this.parent.getTotalScaleFactorY() + this.parent.getGlobalScaledY();
        }
        return this.getY();
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public boolean isActive() {
        if (!this.active) {
            return false;
        }
        if (this.parent == null) {
            return this.active;
        }
        return this.parent.isActive();
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public double getScale() {
        if (this.useCustomScaling) {
            return this.customScale;
        }
        return 1.0;
    }

    public double getScaleX() {
        return this.getScale();
    }

    public double getScaleY() {
        return this.getScale();
    }

    @Override
    public void setRenderScale(GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.x, (float)this.y, 0.0f);
        Quaternionf rotation = new Quaternionf().rotateZ((float)Math.toRadians(this.getRotationZ())).rotateY((float)Math.toRadians(this.getRotationY())).rotateX((float)Math.toRadians(this.getRotationX()));
        guiGraphics.pose().rotateAround(rotation, (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, 1.0f);
        if (this.useCustomScaling) {
            guiGraphics.pose().scale((float)this.getScaleX(), (float)this.getScaleY(), 1.0f);
        }
    }

    @Override
    public void resetRenderScale(GuiGraphics guiGraphics) {
        guiGraphics.pose().popPose();
    }

    @Override
    public void renderChildren(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (ContainerRenderable child : this.getChildren()) {
            if (!child.isActive() || !child.isVisible()) continue;
            child.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public final void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.setRenderScale(guiGraphics);
        this.renderSelf(guiGraphics, mouseX, mouseY, partialTick);
        this.renderChildren(guiGraphics, mouseX, mouseY, partialTick);
        this.resetRenderScale(guiGraphics);
    }

    public double getMinecraftScaling() {
        return Minecraft.getInstance().getWindow().getGuiScale();
    }

    @Override
    public double getTotalCustomScaling() {
        if (this.parent != null) {
            return this.customScale * this.parent.getTotalCustomScaling();
        }
        return this.customScale;
    }

    @Override
    public double getTotalScaleFactorX() {
        if (this.parent != null && this.useCustomScaling) {
            return this.parent.getTotalScaleFactorX() * this.customScale;
        }
        if (this.parent != null) {
            return this.parent.getTotalScaleFactorX();
        }
        if (this.useCustomScaling) {
            return this.customScale;
        }
        return 1.0;
    }

    @Override
    public double getTotalScaleFactorY() {
        if (this.parent != null && this.useCustomScaling) {
            return this.parent.getTotalScaleFactorY() * this.customScale;
        }
        if (this.parent != null) {
            return this.parent.getTotalScaleFactorY();
        }
        if (this.useCustomScaling) {
            return this.customScale;
        }
        return 1.0;
    }

    @Override
    public ContainerRenderable getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    @Override
    public int getScaledWidth() {
        return (int)((double)this.getWidth() * this.getTotalScaleFactorX());
    }

    @Override
    public int getScaledHeight() {
        return (int)((double)this.getHeight() * this.getTotalScaleFactorY());
    }

    @Override
    public void remove() {
        this.screen.unregister(this);
        if (this.getParent() != null) {
            this.parent.getChildren().remove(this);
        }
    }

    public void setCustomScale(double customScale) {
        this.customScale = customScale;
    }

    @Override
    public void setParent(ContainerRenderable parent) {
        this.parent = parent;
    }

    @Override
    public void addChild(ContainerRenderable child) {
        this.children.add(child);
        child.setParent(this);
    }

    public double getCustomScale() {
        return this.customScale;
    }

    @Override
    public List<ContainerRenderable> getChildren() {
        return this.children;
    }

    @Override
    public ContainerRenderable getParent() {
        return this.parent;
    }
}

