/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.controls.buttons;

import net.lucent.easygui.elements.controls.buttons.AbstractButton;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.ITextureData;
import net.minecraft.client.gui.GuiGraphics;

public class TextureButton
extends AbstractButton {
    public ITextureData defaultTexture;
    public ITextureData pressedTexture;
    public ITextureData hoveredTexture;
    public ITextureData focusedTexture;

    public TextureButton(IEasyGuiScreen easyGuiScreen, int x, int y, ITextureData defaultTexture, ITextureData pressedTexture, ITextureData hoveredTexture, ITextureData focusedTexture) {
        super(easyGuiScreen, x, y, defaultTexture.getWidth(), defaultTexture.getHeight());
        this.defaultTexture = defaultTexture;
        this.pressedTexture = pressedTexture;
        this.hoveredTexture = hoveredTexture;
        this.focusedTexture = focusedTexture;
    }

    public TextureButton(IEasyGuiScreen easyGuiScreen, int x, int y, ITextureData defaultTexture, ITextureData pressedTexture, ITextureData hoveredTexture) {
        this(easyGuiScreen, x, y, defaultTexture, pressedTexture, hoveredTexture, defaultTexture);
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ITextureData finalTexture = this.defaultTexture;
        if (this.isFocused()) {
            finalTexture = this.focusedTexture;
        }
        if (this.isHovered()) {
            finalTexture = this.hoveredTexture;
        }
        if (this.isPressed()) {
            finalTexture = this.pressedTexture;
            this.time_pressed += (double)partialTick;
            if (this.time_pressed >= (double)this.PRESSED_TIME) {
                this.setPressed(false);
                this.time_pressed = 0.0;
            }
        }
        finalTexture.renderTexture(guiGraphics, this.getX(), this.getY());
    }
}

