/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.controls.inputs;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.lucent.easygui.elements.other.SquareRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.ITextureData;
import net.lucent.easygui.interfaces.events.CharTypedListener;
import net.lucent.easygui.interfaces.events.Clickable;
import net.lucent.easygui.interfaces.events.KeyPressedListener;
import net.lucent.easygui.interfaces.events.MouseDragListener;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class MultiLineTextBox
extends SquareRenderable
implements Clickable,
KeyPressedListener,
CharTypedListener,
MouseDragListener {
    public String pageText = "";
    public Font font;
    private final Minecraft minecraft;
    private DisplayData displayData;
    private int lastIndex;
    private long lastClickTime;
    public int width;
    public int height;
    private final TextFieldHelper boxData;
    private int textColor;
    private int textColorUnFocused;
    private ITextureData backgroundTexture;
    private int backgroundColor;
    private int borderColor;
    private boolean bordered;
    private int borderWidth;
    private int frameTick;

    public MultiLineTextBox(IEasyGuiScreen easyGuiScreen, int x, int y, int width, int height) {
        super(easyGuiScreen);
        this.font = Minecraft.getInstance().font;
        this.minecraft = Minecraft.getInstance();
        this.lastIndex = -1;
        this.width = 0;
        this.height = 0;
        this.textColor = 0xE0E0E0;
        this.textColorUnFocused = 0x707070;
        this.backgroundTexture = null;
        this.backgroundColor = -16777216;
        this.borderColor = -1;
        this.bordered = false;
        this.borderWidth = 1;
        this.setX(x);
        this.setY(y);
        this.width = width;
        this.height = height;
        this.boxData = new TextFieldHelper(this::getCurrentPageText, this::setCurrentPageText, this::getClipboard, this::setClipboard, value -> {
            int n = this.font.wordWrapHeight(value, width);
            Objects.requireNonNull(this.font);
            return n <= height - 9 - 1;
        });
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public void setTextColorUnFocused(int color) {
        this.textColorUnFocused = color;
    }

    public void setBackgroundTexture(ITextureData texture) {
        this.backgroundTexture = texture;
    }

    public void setBorderColor(int color) {
        this.borderColor = color;
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
    }

    public void setBordered(boolean bordered) {
        this.bordered = bordered;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    private String getCurrentPageText() {
        return this.pageText;
    }

    private void setCurrentPageText(String text) {
        this.pageText = text;
    }

    private void setClipboard(String clipboardValue) {
        if (this.minecraft != null) {
            TextFieldHelper.setClipboardContents((Minecraft)this.minecraft, (String)clipboardValue);
        }
    }

    private String getClipboard() {
        return this.minecraft != null ? TextFieldHelper.getClipboardContents((Minecraft)this.minecraft) : "";
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int textColor = this.textColor;
        if (!this.isFocused()) {
            textColor = this.textColorUnFocused;
        }
        DisplayData displayData = this.getDisplayData();
        if (this.bordered) {
            guiGraphics.fill(-this.borderWidth, -this.borderWidth, this.getWidth() + this.borderWidth, this.getHeight() + this.borderWidth, this.borderColor);
        }
        guiGraphics.fill(0, 0, this.getWidth(), this.getHeight(), this.backgroundColor);
        if (this.backgroundTexture != null) {
            this.backgroundTexture.renderTexture(guiGraphics);
        }
        for (int i = 0; i < displayData.lines.length; ++i) {
            Component component = displayData.lines[i];
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, component, 0, i * (9 + 1), textColor, false);
        }
        if (this.isFocused()) {
            this.renderHighlighted(guiGraphics, displayData.selection);
            this.renderCursor(guiGraphics, displayData.cursorX, displayData.cursorY, displayData.cursorAtEnd);
        }
    }

    private void renderCursor(GuiGraphics guiGraphics, int cursorX, int cursorY, boolean isEndOfText) {
        if (this.frameTick / 6 % 2 == 0) {
            if (!isEndOfText) {
                Objects.requireNonNull(this.font);
                guiGraphics.fill(cursorX, cursorY - 1, cursorX + 1, cursorY + 9 + 1, this.textColor);
            } else {
                guiGraphics.drawString(this.font, "_", cursorX, cursorY, this.textColor, false);
            }
        }
    }

    private void renderHighlighted(GuiGraphics guiGraphics, Rect2i[] highlightAreas) {
        for (Rect2i rect2i : highlightAreas) {
            int i = rect2i.getX();
            int j = rect2i.getY();
            int k = i + rect2i.getWidth();
            int l = j + rect2i.getHeight();
            guiGraphics.fill(RenderType.guiTextHighlight(), i, j, k, l, -16776961);
        }
    }

    @Override
    public void onCharTyped(char codePoint, int modifiers) {
        if (this.isFocused() && StringUtil.isAllowedChatCharacter((char)codePoint)) {
            this.boxData.insertText(Character.toString(codePoint));
            this.clearDisplayData();
        }
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button, boolean clicked) {
        if (clicked && button == 0) {
            this.setFocused(true);
            long clickTime = Util.getMillis();
            DisplayData displayData = this.getDisplayData();
            int index = displayData.getIndexAtPosition(this.font, this.screenToLocalX((int)mouseX), this.screenToLocalY((int)mouseY));
            if (index >= 0) {
                if (index != this.lastIndex || clickTime - this.lastClickTime >= 250L) {
                    this.boxData.setCursorPos(index, Screen.hasShiftDown());
                } else if (!this.boxData.isSelecting()) {
                    this.selectWord(index);
                } else {
                    this.boxData.selectAll();
                }
                this.clearDisplayData();
            }
            this.lastIndex = index;
            this.lastClickTime = clickTime;
        } else {
            this.setFocused(false);
        }
    }

    @Override
    public void onKeyPressed(int keyCode, int scanCode, int modifier) {
        boolean flag;
        if (this.isFocused() && (flag = this.textBoxKeyPressed(keyCode, scanCode, modifier))) {
            this.clearDisplayData();
        }
    }

    public boolean textBoxKeyPressed(int keyCode, int scanCode, int modifier) {
        if (Screen.isSelectAll((int)keyCode)) {
            this.boxData.selectAll();
            return true;
        }
        if (Screen.isCopy((int)keyCode)) {
            this.boxData.copy();
            return true;
        }
        if (Screen.isPaste((int)keyCode)) {
            this.boxData.paste();
            return true;
        }
        if (Screen.isCut((int)keyCode)) {
            this.boxData.cut();
            return true;
        }
        TextFieldHelper.CursorStep textfieldhelper$cursorstep = Screen.hasControlDown() ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
        return switch (keyCode) {
            case 257, 335 -> {
                this.boxData.insertText("\n");
                yield true;
            }
            case 259 -> {
                this.boxData.removeFromCursor(-1, textfieldhelper$cursorstep);
                yield true;
            }
            case 261 -> {
                this.boxData.removeFromCursor(1, textfieldhelper$cursorstep);
                yield true;
            }
            case 262 -> {
                this.boxData.moveBy(1, Screen.hasShiftDown(), textfieldhelper$cursorstep);
                yield true;
            }
            case 263 -> {
                this.boxData.moveBy(-1, Screen.hasShiftDown(), textfieldhelper$cursorstep);
                yield true;
            }
            case 264 -> {
                this.keyDown();
                yield true;
            }
            case 265 -> {
                this.keyUp();
                yield true;
            }
            case 268 -> {
                this.keyHome();
                yield true;
            }
            case 269 -> {
                this.keyEnd();
                yield true;
            }
            default -> false;
        };
    }

    private void keyUp() {
        this.changeLine(-1);
    }

    private void keyDown() {
        this.changeLine(1);
    }

    private void changeLine(int yChange) {
        int i = this.boxData.getCursorPos();
        int j = this.getDisplayData().changeLine(i, yChange);
        this.boxData.setCursorPos(j, Screen.hasShiftDown());
    }

    private void keyHome() {
        if (Screen.hasControlDown()) {
            this.boxData.setCursorToStart(Screen.hasShiftDown());
        } else {
            int i = this.boxData.getCursorPos();
            int j = this.getDisplayData().findLineStart(i);
            this.boxData.setCursorPos(j, Screen.hasShiftDown());
        }
    }

    private void keyEnd() {
        if (Screen.hasControlDown()) {
            this.boxData.setCursorToEnd(Screen.hasShiftDown());
        } else {
            int i = this.boxData.getCursorPos();
            int j = this.getDisplayData().findLineEnd(i);
            this.boxData.setCursorPos(j, Screen.hasShiftDown());
        }
    }

    @Override
    public void onDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isFocused() && button == 0) {
            int i = this.getDisplayData().getIndexAtPosition(this.font, this.screenToLocalX((int)mouseX), this.screenToLocalY((int)mouseY));
            this.boxData.setCursorPos(i, true);
            this.clearDisplayData();
        }
    }

    @Override
    public void tick() {
        ++this.frameTick;
    }

    public DisplayData getDisplayData() {
        if (this.displayData == null) {
            this.displayData = this.buildDisplayData();
        }
        return this.displayData;
    }

    public void clearDisplayData() {
        this.displayData = null;
    }

    public DisplayData buildDisplayData() {
        if (this.pageText.isEmpty()) {
            return DisplayData.EMPTY;
        }
        System.out.println(this.pageText);
        int cursorPos = this.boxData.getCursorPos();
        int selectionPos = this.boxData.getSelectionPos();
        ArrayList lines = new ArrayList();
        IntArrayList intlist = new IntArrayList();
        MutableBoolean mutableboolean = new MutableBoolean();
        this.font.getSplitter().splitLines(this.pageText, this.getWidth(), Style.EMPTY, true, (arg_0, arg_1, arg_2) -> this.lambda$buildDisplayData$1(mutableboolean, (IntList)intlist, lines, arg_0, arg_1, arg_2));
        int[] lineStarts = intlist.toIntArray();
        System.out.println(cursorPos + "," + this.pageText.length());
        boolean endOfPage = cursorPos == this.pageText.length();
        int cursorX = 0;
        int cursorY = 0;
        if (endOfPage && mutableboolean.isTrue()) {
            int n = lines.size();
            Objects.requireNonNull(this.font);
            cursorY = n * (9 + 1);
        } else {
            int line = MultiLineTextBox.findLineFromPos(lineStarts, cursorPos);
            cursorX = this.font.width(this.pageText.substring(lineStarts[line], cursorPos));
            Objects.requireNonNull(this.font);
            cursorY = line * (9 + 1);
        }
        ArrayList selections = Lists.newArrayList();
        if (cursorPos != selectionPos) {
            int endLine;
            int startPos = Math.min(cursorPos, selectionPos);
            int endPos = Math.max(cursorPos, selectionPos);
            int startLine = MultiLineTextBox.findLineFromPos(lineStarts, startPos);
            if (startLine == (endLine = MultiLineTextBox.findLineFromPos(lineStarts, endPos))) {
                Objects.requireNonNull(this.font);
                int yPos = startLine * (9 + 1);
                selections.add(this.createPartialLineSelection(this.pageText, this.font.getSplitter(), startPos, endPos, yPos, lineStarts[startLine]));
            } else {
                int endCord = startLine + 1 > lineStarts.length ? this.pageText.length() : lineStarts[startLine + 1];
                StringSplitter stringSplitter = this.font.getSplitter();
                Objects.requireNonNull(this.font);
                selections.add(this.createPartialLineSelection(this.pageText, stringSplitter, startPos, endCord, startLine * (9 + 1), lineStarts[startLine]));
                for (int i = startLine + 1; i < endLine; ++i) {
                    Objects.requireNonNull(this.font);
                    int lineCord = i * (9 + 1);
                    String s1 = this.pageText.substring(lineStarts[i], lineStarts[i + 1]);
                    int width = (int)this.font.getSplitter().stringWidth(s1);
                    Objects.requireNonNull(this.font);
                    selections.add(this.createSelection(0, lineCord, width, lineCord + (9 + 1)));
                }
                StringSplitter stringSplitter2 = this.font.getSplitter();
                int n = lineStarts[endLine];
                Objects.requireNonNull(this.font);
                selections.add(this.createPartialLineSelection(this.pageText, stringSplitter2, n, endPos, endLine * (9 + 1), lineStarts[endLine]));
            }
        }
        return new DisplayData(this.pageText, cursorX, cursorY, lineStarts, lines.toArray(new Component[0]), selections.toArray(new Rect2i[0]), endOfPage);
    }

    private static int findLineFromPos(int[] lineStarts, int find) {
        int i = Arrays.binarySearch(lineStarts, find);
        return i < 0 ? -(i + 2) : i;
    }

    private Rect2i createPartialLineSelection(String input, StringSplitter splitter, int startPos, int endPos, int y, int lineStart) {
        String s = input.substring(lineStart, startPos);
        String s1 = input.substring(lineStart, endPos);
        int x1 = (int)splitter.stringWidth(s);
        int y1 = y;
        int x2 = (int)splitter.stringWidth(s1);
        Objects.requireNonNull(this.font);
        int y2 = y + (9 + 1);
        return this.createSelection(x1, y1, x2, y2);
    }

    private Rect2i createSelection(int x1, int y1, int x2, int y2) {
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        int minY = Math.min(y1, y2);
        int maxY = Math.max(y1, y2);
        return new Rect2i(minX, minY, maxX - minX, maxY - minY);
    }

    private void selectWord(int index) {
        String s = this.getCurrentPageText();
        this.boxData.setSelectionRange(StringSplitter.getWordPosition((String)s, (int)-1, (int)index, (boolean)false), StringSplitter.getWordPosition((String)s, (int)1, (int)index, (boolean)false));
    }

    private /* synthetic */ void lambda$buildDisplayData$1(MutableBoolean mutableboolean, IntList intlist, List lines, Style style, int i, int i1) {
        String s2 = this.pageText.substring(i, i1);
        mutableboolean.setValue(s2.endsWith("\n"));
        System.out.println(mutableboolean.getValue());
        String s3 = StringUtils.stripEnd((String)s2, (String)" \n");
        intlist.add(i);
        lines.add(Component.literal((String)s3));
    }

    public static class DisplayData {
        public static DisplayData EMPTY = new DisplayData("", 0, 0, new int[]{0}, new Component[]{Component.empty()}, new Rect2i[0], true);
        public int cursorX;
        public int cursorY;
        private final String text;
        private Rect2i[] selection;
        private final int[] lineStarts;
        private boolean cursorAtEnd;
        private Component[] lines;

        public DisplayData(String text, int cursorX, int cursorY, int[] lineStarts, Component[] lines, Rect2i[] selection, boolean cursorAtEnd) {
            this.text = text;
            this.lineStarts = lineStarts;
            this.lines = lines;
            this.selection = selection;
            this.cursorAtEnd = cursorAtEnd;
            this.cursorX = cursorX;
            this.cursorY = cursorY;
        }

        public int getIndexAtPosition(Font font, int cursorX, int cursorY) {
            Objects.requireNonNull(font);
            int line = cursorY / (9 + 1);
            if (line < 0) {
                return 0;
            }
            if (line >= this.lines.length) {
                return this.text.length();
            }
            Component component = this.lines[line];
            return this.lineStarts[line] + font.getSplitter().plainIndexAtWidth(component.getString(), cursorX, Style.EMPTY);
        }

        public int changeLine(int xChange, int yChange) {
            int xPos;
            int line = MultiLineTextBox.findLineFromPos(this.lineStarts, xChange);
            int newLine = line + yChange;
            if (0 <= newLine && newLine < this.lineStarts.length) {
                int x1 = xChange - this.lineStarts[line];
                int x2 = this.lines[newLine].getString().length();
                xPos = this.lineStarts[newLine] + Math.min(x1, x2);
            } else {
                xPos = xChange;
            }
            return xPos;
        }

        public int findLineStart(int line) {
            int i = MultiLineTextBox.findLineFromPos(this.lineStarts, line);
            return this.lineStarts[i];
        }

        public int findLineEnd(int line) {
            int i = MultiLineTextBox.findLineFromPos(this.lineStarts, line);
            return this.lineStarts[i] + this.lines[i].getString().length();
        }
    }
}

