/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.controls.inputs;

import java.util.Objects;
import java.util.function.Consumer;
import net.lucent.easygui.elements.controls.inputs.EnhancedEditBox;
import net.lucent.easygui.elements.other.SquareRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.complex_events.Draggable;
import net.lucent.easygui.interfaces.events.CharTypedListener;
import net.lucent.easygui.interfaces.events.KeyPressedListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class TextBox
extends SquareRenderable
implements Draggable,
CharTypedListener,
KeyPressedListener {
    private boolean editable = false;
    private final EnhancedEditBox editBox;
    private final Font font;
    private boolean dragging;
    private int draggingX;
    private Component hint = null;

    public TextBox(IEasyGuiScreen easyGuiScreen, int x, int y, int width) {
        super(easyGuiScreen);
        this.setX(x);
        this.setY(y);
        this.font = Minecraft.getInstance().font;
        Objects.requireNonNull(this.font);
        this.editBox = new EnhancedEditBox(this.font, width, 9 + 2, (Component)Component.empty());
    }

    @Override
    public int getWidth() {
        return this.editBox.getWidth();
    }

    @Override
    public int getHeight() {
        return this.editBox.getHeight();
    }

    public void setHint(Component hint) {
        this.hint = hint;
    }

    public void setEditable(boolean editable) {
        this.editBox.setEditable(editable);
        this.editable = editable;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setPivot(int pivotX) {
        this.draggingX = pivotX;
    }

    @Override
    public boolean isDragged() {
        return this.dragging;
    }

    @Override
    public void setDragged(boolean state) {
        this.dragging = state;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button, boolean clicked) {
        System.out.println("clicked");
        if (!clicked) {
            this.setEditable(false);
            this.setFocused(false);
            return;
        }
        if (this.isFocused()) {
            System.out.println("enhanced click");
            this.editBox.enhancedOnClick(mouseX, mouseY, button, (int)this.getGlobalScaledX(), this.getTotalScaleFactorX());
        } else {
            this.setEditable(true);
            this.setFocused(true);
        }
        if (clicked && button == 0) {
            this.setDragged(true);
            this.setPivot((int)(((double)Mth.floor((double)mouseX) - this.getGlobalScaledX()) / this.getTotalScaleFactorX()));
        }
    }

    @Override
    public void onMouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.setDragged(false);
            this.setPivot(0);
        }
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (focused != this.editBox.isFocused()) {
            this.editBox.setFocused(focused);
        }
    }

    public String getValue() {
        return this.editBox.getValue();
    }

    public void setValue(String value) {
        this.editBox.setValue(value);
    }

    public void setValueWithoutNotification(String value) {
        Consumer temp = this.editBox.responder;
        this.editBox.setResponder(null);
        this.editBox.setValue(value);
        this.editBox.setResponder(temp);
    }

    public void setTextColor(int color) {
        this.editBox.setTextColor(color);
    }

    public void setTextColorUneditable(int color) {
        this.editBox.setTextColorUneditable(color);
    }

    public void setBordered(boolean bordered) {
        this.editBox.setBordered(bordered);
        if (!bordered) {
            this.editBox.setX(this.getX() + 1);
            this.editBox.setY(this.getY() + 1);
            this.editBox.setWidth(this.getWidth() - 6);
        } else {
            this.editBox.setX(this.getX());
            this.editBox.setY(this.getY());
            this.editBox.setWidth(this.getWidth());
        }
    }

    public void setResponder(Consumer<String> responder) {
        this.editBox.setResponder(responder);
    }

    public void setMaxLength(int length) {
        this.editBox.setMaxLength(length);
    }

    @Override
    public void onCharTyped(char codePoint, int modifiers) {
        this.editBox.charTyped(codePoint, modifiers);
    }

    @Override
    public void onKeyPressed(int keyCode, int scanCode, int modifier) {
        if (!this.isFocused()) {
            return;
        }
        this.editBox.keyPressed(keyCode, scanCode, modifier);
        if (keyCode == 257) {
            this.onEnter();
        }
    }

    public void onEnter() {
    }

    @Override
    public void onMouseOver(boolean state) {
        Draggable.super.onMouseOver(state);
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.editBox.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        if (this.editBox.getValue().isEmpty() && this.hint != null && !this.editBox.isFocused()) {
            guiGraphics.drawCenteredString(this.font, this.hint, this.getWidth() / 2, this.getHeight() / 2, this.editBox.textColor);
        }
    }

    @Override
    public void onDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int distance = (int)(((double)Mth.floor((double)mouseX) - this.getGlobalScaledX()) / this.getTotalScaleFactorX());
        this.editBox.highlightSubstring(distance);
    }
}

