/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.other;

import java.awt.Color;
import java.util.Objects;
import net.lucent.easygui.elements.BaseRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class Label
extends BaseRenderable {
    public int textColor;
    public boolean centered;
    public int width;
    public int height;
    public Component text;
    public Font font;
    public boolean cull;

    private Label(IEasyGuiScreen easyGuiScreen, Font font, Component text, int x, int y, int width, int height, boolean centered, boolean cull, int textColor) {
        super(easyGuiScreen);
        this.font = font;
        this.text = text;
        this.setY(y);
        this.setX(x);
        this.width = width;
        this.height = height;
        this.centered = centered;
        this.cull = cull;
        this.textColor = textColor;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setRenderScale(GuiGraphics guiGraphics) {
        super.setRenderScale(guiGraphics);
        if (this.cull) {
            guiGraphics.enableScissor(0, 0, this.getScaledWidth(), this.getScaledHeight());
        }
    }

    @Override
    public void resetRenderScale(GuiGraphics guiGraphics) {
        super.resetRenderScale(guiGraphics);
        if (this.cull) {
            guiGraphics.disableScissor();
        }
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.centered) {
            guiGraphics.pose().translate((float)(-this.getWidth()) / 2.0f, (float)(-this.getHeight()) / 2.0f, 0.0f);
        }
        guiGraphics.drawWordWrap(this.getFont(), (FormattedText)this.text, 0, 0, this.getWidth(), this.textColor);
    }

    public static class Builder {
        private IEasyGuiScreen easyGuiScreen = null;
        private int textColor = -16777216;
        private boolean centered = false;
        private Integer width;
        private Integer height;
        private Component text = Component.literal((String)"");
        private Font font;
        private boolean cull;
        private boolean useCustomScaling;
        private double customScaling;
        private int x;
        private int y;

        public Builder() {
            this.font = Minecraft.getInstance().font;
            this.cull = false;
            this.useCustomScaling = false;
            this.customScaling = 1.0;
        }

        public Builder screen(IEasyGuiScreen easyGuiScreen) {
            this.easyGuiScreen = easyGuiScreen;
            return this;
        }

        public Builder textColor(int color) {
            this.textColor = color;
            return this;
        }

        public Builder textColor(Color color) {
            this.textColor = color.getRGB();
            return this;
        }

        public Builder centered(boolean centered) {
            this.centered = centered;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder height(int height) {
            this.height = height;
            return this;
        }

        public Builder text(Component component) {
            this.text = component;
            return this;
        }

        public Builder text(String text) {
            this.text = Component.literal((String)text);
            return this;
        }

        public Builder translatableText(String key) {
            this.text = Component.translatable((String)key);
            return this;
        }

        public Builder font(Font font) {
            this.font = font;
            return this;
        }

        public Builder cull(boolean cull) {
            this.cull = cull;
            return this;
        }

        public Builder customScaling(int scale) {
            this.useCustomScaling = true;
            this.customScaling = scale;
            return this;
        }

        public Builder x(int x) {
            this.x = x;
            return this;
        }

        public Builder y(int y) {
            this.y = y;
            return this;
        }

        public Label build() {
            if (this.easyGuiScreen == null) {
                throw new IllegalArgumentException("Label must have a valid event handler");
            }
            if (this.width == null) {
                this.width = this.font.width((FormattedText)this.text);
            }
            if (this.height == null) {
                Objects.requireNonNull(this.font);
                this.height = 9;
            }
            Label label = new Label(this.easyGuiScreen, this.font, this.text, this.x, this.y, this.width, this.height, this.centered, this.cull, this.textColor);
            label.useCustomScaling = this.useCustomScaling;
            label.setCustomScale(this.customScaling);
            return label;
        }
    }
}

