/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.other;

import net.lucent.easygui.elements.BaseRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.ITextureData;
import net.minecraft.client.gui.GuiGraphics;

public abstract class ProgressBar
extends BaseRenderable {
    public ITextureData background;
    public ITextureData barTexture;
    public boolean vertical = false;
    public int x;
    public int y;

    public ProgressBar(IEasyGuiScreen easyGuiScreen, ITextureData progressBarTexture, int x, int y) {
        super(easyGuiScreen);
        this.setX(x);
        this.setY(y);
        this.barTexture = progressBarTexture;
    }

    public ProgressBar(IEasyGuiScreen easyGuiScreen, ITextureData progressBarTexture, boolean vertical, int x, int y) {
        this(easyGuiScreen, progressBarTexture, x, y);
        this.barTexture = progressBarTexture;
        this.vertical = vertical;
    }

    public ProgressBar(IEasyGuiScreen easyGuiScreen, ITextureData progressBarTexture, ITextureData background, boolean vertical, int x, int y) {
        this(easyGuiScreen, progressBarTexture, vertical, x, y);
        this.background = background;
    }

    public ProgressBar(IEasyGuiScreen easyGuiScreen, ITextureData progressBarTexture, ITextureData background, int x, int y) {
        this(easyGuiScreen, progressBarTexture, x, y);
        this.background = background;
    }

    public abstract double getProgress();

    public int getProgressLength() {
        if (this.vertical) {
            return (int)((double)this.getHeight() * this.getProgress());
        }
        return (int)((double)this.getWidth() * this.getProgress());
    }

    @Override
    public int getWidth() {
        return this.background.getWidth();
    }

    @Override
    public int getHeight() {
        return this.background.getWidth();
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.background != null) {
            this.background.renderTexture(guiGraphics);
        }
        if (this.vertical) {
            this.barTexture.renderTexture(guiGraphics, 0, 0, 0, 0, this.barTexture.getWidth(), this.getProgressLength());
        } else {
            this.barTexture.renderTexture(guiGraphics, 0, 0, 0, 0, this.getProgressLength(), this.barTexture.getHeight());
        }
    }
}

