/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.other;

import com.mojang.blaze3d.platform.Window;
import net.lucent.easygui.elements.BaseRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.events.GuiScaleListener;
import net.lucent.easygui.interfaces.events.ScreenResizeListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class View
extends BaseRenderable
implements ScreenResizeListener,
GuiScaleListener {
    public boolean useViewportSize = false;
    public boolean useMinecraftScale = false;
    public int width;
    public int height;

    public View(IEasyGuiScreen screen, int x, int y) {
        this(screen, x, y, Minecraft.getInstance().getWindow().getWidth(), Minecraft.getInstance().getWindow().getHeight());
    }

    public View(IEasyGuiScreen screen, int x, int y, int width, int height) {
        super(screen);
        this.setX(x);
        this.setY(y);
        this.width = width;
        this.height = height;
        this.screen = screen;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public double getScale() {
        double finalScale = 1.0;
        if (this.useCustomScaling) {
            finalScale *= this.getCustomScale();
        }
        if (this.useMinecraftScale) {
            finalScale *= Minecraft.getInstance().getWindow().getGuiScale();
        }
        return finalScale / Minecraft.getInstance().getWindow().getGuiScale();
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public double getTotalScaleFactorX() {
        return this.getScaleX();
    }

    @Override
    public double getTotalScaleFactorY() {
        return this.getScaleY();
    }

    @Override
    public double getScaleX() {
        double finalScale = this.getScale();
        if (this.useViewportSize) {
            Window win = Minecraft.getInstance().getWindow();
            finalScale *= (double)win.getWidth() / (double)win.getScreenWidth();
        }
        return finalScale;
    }

    @Override
    public double getScaleY() {
        Window win = Minecraft.getInstance().getWindow();
        double finalScale = this.getScale();
        if (this.useViewportSize) {
            finalScale *= (double)win.getHeight() / (double)win.getScreenHeight();
        }
        return finalScale;
    }

    @Override
    public void remove() {
        this.screen.unregister(this);
        this.screen.removeView(this);
    }

    @Override
    public int getScaledHeight() {
        return (int)((double)this.getHeight() / this.getTotalScaleFactorY());
    }

    @Override
    public int getScaledWidth() {
        return (int)((double)this.getWidth() / this.getTotalScaleFactorX());
    }

    @Override
    public void onResize(int oldWidth, int oldHeight) {
        this.recalculateDimensions();
    }

    public void recalculateDimensions() {
        System.out.println("recalculation");
        if (this.useMinecraftScale) {
            this.width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            this.height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        } else {
            this.width = Minecraft.getInstance().getWindow().getWidth();
            this.height = Minecraft.getInstance().getWindow().getHeight();
        }
    }

    @Override
    public void setCustomScale(double scale) {
        super.setCustomScale(scale);
        this.recalculateDimensions();
    }

    public void setUseMinecraftScale(boolean useMinecraftScale) {
        this.useMinecraftScale = useMinecraftScale;
        this.recalculateDimensions();
    }

    @Override
    public boolean usesMinecraftScaling() {
        return this.useMinecraftScale;
    }

    @Override
    public void onGuiScaleChanged(double oldScale) {
        this.recalculateDimensions();
    }
}

