/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.interfaces;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;

public interface ContainerRenderable {
    public void render(GuiGraphics var1, int var2, int var3, float var4);

    public void renderSelf(GuiGraphics var1, int var2, int var3, float var4);

    public void renderChildren(GuiGraphics var1, int var2, int var3, float var4);

    public void setRenderScale(GuiGraphics var1);

    public void resetRenderScale(GuiGraphics var1);

    default public boolean isActive() {
        return false;
    }

    public void setActive(boolean var1);

    default public boolean isVisible() {
        return false;
    }

    public void setVisible(boolean var1);

    default public boolean isFocused() {
        return false;
    }

    public void setFocused(boolean var1);

    public int getX();

    public int getY();

    public void setX(int var1);

    public void setY(int var1);

    default public void setRotation(double x, double y, double z) {
    }

    default public double getRotationX() {
        return 0.0;
    }

    default public double getRotationY() {
        return 0.0;
    }

    default public double getRotationZ() {
        return 0.0;
    }

    default public boolean usesMinecraftScaling() {
        return false;
    }

    default public double getTotalCustomScaling() {
        return 1.0;
    }

    default public double getTotalScaleFactorX() {
        return 1.0;
    }

    default public double getTotalScaleFactorY() {
        return 1.0;
    }

    default public double getGlobalScaledX() {
        return 0.0;
    }

    default public double getGlobalScaledY() {
        return 0.0;
    }

    public ContainerRenderable getParent();

    public ContainerRenderable getRoot();

    public List<ContainerRenderable> getChildren();

    default public int getWidth() {
        return 0;
    }

    default public int getHeight() {
        return 0;
    }

    default public int getScaledWidth() {
        return this.getWidth();
    }

    default public int getScaledHeight() {
        return this.getHeight();
    }

    public void setParent(ContainerRenderable var1);

    public void addChild(ContainerRenderable var1);

    public void remove();

    default public int screenToLocalX(int x) {
        return (int)(((double)x - this.getGlobalScaledX()) / this.getTotalCustomScaling());
    }

    default public int screenToLocalY(int y) {
        return (int)(((double)y - this.getGlobalScaledY()) / this.getTotalCustomScaling());
    }

    default public void tick() {
    }
}

