/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.overlays;

import java.util.function.BiConsumer;
import net.lucent.easygui.elements.other.View;
import net.lucent.easygui.holders.EasyGuiEventHolder;
import net.lucent.easygui.interfaces.ContainerRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@OnlyIn(value=Dist.CLIENT)
public class EasyGuiOverlay
implements IEasyGuiScreen {
    public int windowWidth = Minecraft.getInstance().getWindow().getWidth();
    public int windowHeight = Minecraft.getInstance().getWindow().getHeight();
    public double guiScale;
    private View view;
    public EasyGuiEventHolder eventHolder;
    public BiConsumer<EasyGuiEventHolder, EasyGuiOverlay> runnable;

    public EasyGuiOverlay(BiConsumer<EasyGuiEventHolder, EasyGuiOverlay> initialize) {
        this.guiScale = ((Integer)Minecraft.getInstance().options.guiScale().get()).intValue();
        this.eventHolder = new EasyGuiEventHolder();
        this.runnable = initialize;
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    private void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        this.runnable.accept(this.eventHolder, this);
    }

    @SubscribeEvent
    private void onClientTick(ClientTickEvent.Pre event) {
        double mouseX = Minecraft.getInstance().mouseHandler.xpos();
        double mouseY = Minecraft.getInstance().mouseHandler.ypos();
        this.eventHolder.TICK_EVENT.call();
        this.eventHolder.MOUSE_OVER_EVENT.call(mouseX, mouseY);
    }

    @SubscribeEvent
    public void onScroll(InputEvent.MouseScrollingEvent event) {
        this.eventHolder.MOUSE_SCROLL_EVENT.call(event.getMouseX(), event.getMouseY(), event.getScrollDeltaX(), event.getScrollDeltaY());
    }

    @SubscribeEvent
    public void onMouseClick(InputEvent.MouseButton.Pre event) {
        double mouseX = Minecraft.getInstance().mouseHandler.xpos();
        double mouseY = Minecraft.getInstance().mouseHandler.ypos();
        if (event.getAction() == 1 || event.getAction() == 2) {
            this.eventHolder.CLICK_EVENT.call(mouseX, mouseY, event.getButton());
            return;
        }
        this.eventHolder.MOUSE_RELEASE_EVENT.call(mouseX, mouseY, event.getButton());
    }

    void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getWindow().getHeight() != this.windowHeight || this.windowWidth != mc.getWindow().getWidth()) {
            this.eventHolder.SCREEN_RESIZE_EVENT.call(this.windowWidth, this.windowHeight);
            this.windowWidth = mc.getWindow().getWidth();
            this.windowHeight = mc.getWindow().getHeight();
        }
        if (mc.getWindow().getGuiScale() != this.guiScale) {
            this.eventHolder.GUI_SCALE_CHANGED_EVENT.call(this.guiScale);
            this.guiScale = mc.getWindow().getGuiScale();
        }
        this.view.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void register(ContainerRenderable renderable) {
        this.eventHolder.register(renderable);
    }

    @Override
    public void unregister(ContainerRenderable renderable) {
        this.eventHolder.unregister(renderable);
    }

    @Override
    public void removeView(View view) {
    }
}

