/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.screens;

import java.util.ArrayList;
import java.util.List;
import net.lucent.easygui.elements.other.View;
import net.lucent.easygui.holders.EasyGuiEventHolder;
import net.lucent.easygui.interfaces.ContainerRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class EasyGuiBaseScreen
extends Screen
implements IEasyGuiScreen {
    private final List<View> views = new ArrayList<View>();
    private final EasyGuiEventHolder eventHolder = new EasyGuiEventHolder();

    public EasyGuiBaseScreen(Component title) {
        super(title);
    }

    public EasyGuiEventHolder getEventHolder() {
        return this.eventHolder;
    }

    public void addView(View view) {
        this.views.add(view);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        for (View view : this.views) {
            if (!view.isActive()) continue;
            view.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void register(ContainerRenderable renderable) {
        this.eventHolder.register(renderable);
    }

    @Override
    public void unregister(ContainerRenderable renderable) {
        this.eventHolder.unregister(renderable);
    }

    @Override
    public void removeView(View view) {
        this.views.remove(view);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.eventHolder.KEY_PRESS_EVENT.call(keyCode, scanCode, modifiers);
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.eventHolder.MOUSE_MOVED_EVENT.call(mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.eventHolder.MOUSE_SCROLL_EVENT.call(mouseX, mouseY, scrollX, scrollY);
        return true;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.eventHolder.KEY_RELEASED_EVENT.call(keyCode, scanCode, modifiers);
        return true;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        this.eventHolder.CHAR_TYPED_EVENT.call(codePoint, modifiers);
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.eventHolder.CLICK_EVENT.call(mouseX, mouseY, button);
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.eventHolder.MOUSE_RELEASE_EVENT.call(mouseX, mouseY, button);
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.eventHolder.MOUSE_DRAG_EVENT.call(mouseX, mouseY, button, dragX, dragY);
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        super.tick();
        double scale = ((Integer)Minecraft.getInstance().options.guiScale().get()).intValue();
        double mouseX = Minecraft.getInstance().mouseHandler.xpos();
        double mouseY = Minecraft.getInstance().mouseHandler.ypos();
        this.eventHolder.MOUSE_OVER_EVENT.call(mouseX / scale, mouseY / scale);
        this.eventHolder.TICK_EVENT.call();
    }
}

