/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter;

import igentuman.spatialcrafter.CommonConfig;
import igentuman.spatialcrafter.Setup;
import igentuman.spatialcrafter.client.SpatialCrafterScreen;
import igentuman.spatialcrafter.integration.compactmachines.CCUtil;
import igentuman.spatialcrafter.network.NetworkHandler;
import igentuman.spatialcrafter.util.MultiblocksProvider;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="spatialcrafter")
@Mod.EventBusSubscriber
public class Main {
    public static final String MODID = "spatialcrafter";
    public static final Logger logger = LogManager.getLogger();

    public Main() {
        this(FMLJavaModLoadingContext.get());
    }

    public Main(FMLJavaModLoadingContext context) {
        Setup.init();
        context.getModEventBus().addListener(Main::init);
        context.getModEventBus().addListener(this::commonSetup);
        context.getModEventBus().addListener(this::addCreative);
        CommonConfig.register();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> NetworkHandler.registerPackets());
    }

    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)Setup.SPATIAL_CRAFTER_CONTAINER.get()), SpatialCrafterScreen::new));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(Setup.SPATIAL_CRAFTER_ITEM);
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        if (((Boolean)CommonConfig.GENERAL.replace_vanilla_recipes.get()).booleanValue() && ModList.get().isLoaded("compactmachines")) {
            CCUtil.disableVanillaRecipes();
        }
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)MultiblocksProvider.getInstance());
    }

    public static ResourceLocation rlFromString(String name) {
        return ResourceLocation.m_135820_((String)name);
    }

    public static ResourceLocation rl(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name);
    }
}

