/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.block;

import igentuman.spatialcrafter.CommonConfig;
import igentuman.spatialcrafter.Main;
import igentuman.spatialcrafter.Setup;
import igentuman.spatialcrafter.client.SpatialCrafterOverlayHandler;
import igentuman.spatialcrafter.recipe.SpatialCrafterRecipe;
import igentuman.spatialcrafter.recipe.SpatialCrafterRecipeManager;
import igentuman.spatialcrafter.util.CustomEnergyStorage;
import igentuman.spatialcrafter.util.WorldUtil;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SpatialCrafterBlockEntity
extends BlockEntity {
    private static final Executor SCAN_EXECUTOR = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 2), r -> {
        Thread t = new Thread(r, "SpatialCrafter");
        t.setPriority(9);
        t.setDaemon(true);
        return t;
    });
    private final CustomEnergyStorage energy = this.createEnergyStorage();
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this.energy);
    private final ItemStackHandler itemHandler = this.createItemHandler();
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemHandler);
    private SpatialCrafterRecipe currentRecipe;
    private int processingProgress = 0;
    private boolean isProcessing = false;
    private HashMap<Long, BlockState> indexedBlockStates = new HashMap();
    private int size = 5;
    private CompletableFuture<Void> currentScan = null;
    public boolean isDisabled = false;
    private long tick = 0L;

    private int size(int inputSize) {
        return Math.max(1, Math.min(27, inputSize));
    }

    public SpatialCrafterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Setup.SPATIAL_CRAFTER_BE.get(), pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SpatialCrafterOverlayHandler.addSpatialCrafterBlock(this.f_58858_));
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.energyHandler.invalidate();
        this.itemHandlerLazyOptional.invalidate();
        if (this.currentScan != null && !this.currentScan.isDone()) {
            this.currentScan.cancel(true);
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SpatialCrafterOverlayHandler.removeSpatialCrafterBlock(this.f_58858_));
        }
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                SpatialCrafterBlockEntity.this.m_6596_();
            }
        };
    }

    public int getEnergy() {
        return this.energy.getEnergyStored();
    }

    public void consumeEnergy(int amount) {
        this.energy.consumeEnergy(amount);
    }

    private void updateRedstoneControl() {
        this.isDisabled = this.f_58857_.m_277086_(this.f_58858_) > 0;
    }

    public void tickServer() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        ++this.tick;
        boolean wasDisabled = this.isDisabled;
        if (this.f_58857_.m_46467_() % 10L == 0L) {
            this.updateRedstoneControl();
        }
        if (wasDisabled != this.isDisabled) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(this.isDisabled && this.isProcessing)), 3);
            this.m_6596_();
        }
        if (this.isDisabled) {
            return;
        }
        if (this.isProcessing && this.currentRecipe != null) {
            this.processCrafting();
        } else if (this.f_58857_.m_46467_() % 40L == 0L) {
            this.isProcessing = false;
            this.scanForRecipe();
        }
        if (this.f_58857_.m_46467_() % 20L == 0L) {
            if (this.currentRecipe != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    private void scanForRecipe() {
        if (this.f_58857_ == null || this.isProcessing && this.currentRecipe != null) {
            return;
        }
        if (this.currentScan != null && !this.currentScan.isDone()) {
            return;
        }
        Level capturedLevel = this.f_58857_;
        BlockPos capturedPos = this.f_58858_.m_7949_();
        int capturedSize = this.size;
        this.currentScan = ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.indexBlockStatesAsync(capturedLevel, capturedPos, capturedSize), SCAN_EXECUTOR).thenCompose(indexedStates -> CompletableFuture.supplyAsync(() -> SpatialCrafterRecipeManager.findRecipe(capturedLevel, indexedStates), SCAN_EXECUTOR))).thenAcceptAsync(recipe -> {
            if (this.f_58857_ != null && !this.m_58901_() && !this.isProcessing) {
                recipe.ifPresent(this::startCrafting);
            }
        }, arg_0 -> ((MinecraftServer)this.f_58857_.m_7654_()).execute(arg_0))).exceptionally(throwable -> {
            Main.logger.error("Error during recipe scanning for SpatialCrafter at {}: {}", (Object)capturedPos, (Object)throwable.getMessage());
            return null;
        });
    }

    private HashMap<Long, BlockState> indexBlockStatesAsync(Level level, BlockPos centerPos, int scanSize) {
        HashMap<Long, BlockState> states = new HashMap<Long, BlockState>();
        BlockState state = WorldUtil.getBlockState(centerPos, (ServerLevel)level);
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockPos scanCenterPos = centerPos.m_5484_(facing.m_122424_(), scanSize);
        AABB scanArea = this.getScanArea();
        BlockPos min = new BlockPos((int)scanArea.f_82288_, (int)scanArea.f_82289_, (int)scanArea.f_82290_);
        BlockPos max = new BlockPos((int)scanArea.f_82291_, (int)scanArea.f_82292_, (int)scanArea.f_82293_);
        BlockPos center = new BlockPos((min.m_123341_() + max.m_123341_()) / 2, (min.m_123342_() + max.m_123342_()) / 2, (min.m_123343_() + max.m_123343_()) / 2);
        for (int x = min.m_123341_(); x <= max.m_123341_(); ++x) {
            for (int y = min.m_123342_(); y <= max.m_123342_(); ++y) {
                for (int z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                    BlockPos relativePos = new BlockPos(x - center.m_123341_(), y - center.m_123342_(), z - center.m_123343_());
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockState blockState = WorldUtil.getBlockState(currentPos, (ServerLevel)level);
                    states.put(relativePos.m_121878_(), blockState);
                }
            }
        }
        return states;
    }

    public void startCrafting(SpatialCrafterRecipe craftingRecipe) {
        if (this.f_58857_ == null || this.isProcessing) {
            return;
        }
        this.currentRecipe = craftingRecipe;
        if (!craftingRecipe.getDoNotDestroy()) {
            this.clearArea();
        }
        this.processingProgress = 0;
        this.isProcessing = true;
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)Setup.SPATIAL_CRAFTER_START.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
        this.m_6596_();
    }

    private void clearArea() {
        if (this.f_58857_ == null || this.currentRecipe == null) {
            return;
        }
        AABB scanArea = this.getScanArea();
        BlockPos min = new BlockPos((int)scanArea.f_82288_, (int)scanArea.f_82289_, (int)scanArea.f_82290_);
        BlockPos max = new BlockPos((int)scanArea.f_82291_, (int)scanArea.f_82292_, (int)scanArea.f_82293_);
        for (int x = min.m_123341_(); x <= max.m_123341_(); ++x) {
            for (int y = min.m_123342_(); y <= max.m_123342_(); ++y) {
                for (int z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    this.f_58857_.m_7731_(currentPos, Blocks.f_50016_.m_49966_(), 2);
                }
            }
        }
    }

    private void processCrafting() {
        if (!this.isProcessing || this.currentRecipe == null || this.f_58857_ == null) {
            return;
        }
        int adjustedEnergyConsumption = this.currentRecipe.getEnergyConsumption() * (Integer)CommonConfig.GENERAL.recipe_energy_multiplier.get();
        int adjustedProcessingTime = (int)((double)this.currentRecipe.getProcessingTime() * (Double)CommonConfig.GENERAL.recipe_time_multiplier.get());
        int energyPerTick = adjustedEnergyConsumption / adjustedProcessingTime;
        if (this.energy.getEnergyStored() < energyPerTick) {
            return;
        }
        this.energy.consumeEnergy(energyPerTick);
        ++this.processingProgress;
        if (this.processingProgress >= adjustedProcessingTime) {
            this.completeCrafting();
        }
        this.m_6596_();
    }

    private void completeCrafting() {
        if (this.currentRecipe == null || this.f_58857_ == null) {
            return;
        }
        for (ItemStack output : this.currentRecipe.getOutputs()) {
            ItemStack result = output.m_41777_();
            if (!this.currentRecipe.getOutputNbt().m_128456_()) {
                CompoundTag existingNbt = result.m_41784_();
                existingNbt.m_128391_(this.currentRecipe.getOutputNbt());
            }
            for (int i = 0; i < this.itemHandler.getSlots() && !(result = this.itemHandler.insertItem(i, result, false)).m_41619_(); ++i) {
            }
            if (result.m_41619_()) continue;
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_.m_7494_(), (ItemStack)result);
        }
        if (((Boolean)CommonConfig.GENERAL.enable_entity_spawning.get()).booleanValue()) {
            for (SpatialCrafterRecipe.EntityOutput entityOutput : this.currentRecipe.getEntityOutputs()) {
                for (int i = 0; i < entityOutput.getCount(); ++i) {
                    Entity entity = entityOutput.getEntityType().m_20615_(this.f_58857_);
                    if (entity == null) continue;
                    if (!entityOutput.getNbt().m_128456_()) {
                        entity.m_20258_(entityOutput.getNbt());
                    }
                    BlockPos center = new BlockPos((int)this.getScanArea().m_82399_().f_82479_, (int)this.getScanArea().m_82399_().f_82480_, (int)this.getScanArea().m_82399_().f_82481_);
                    BlockPos spawnPos = center.m_121955_((Vec3i)entityOutput.getRelativePos());
                    entity.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)(spawnPos.m_123342_() - 1), (double)spawnPos.m_123343_() + 0.5);
                    this.f_58857_.m_7967_(entity);
                }
            }
        }
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)Setup.SPATIAL_CRAFTER_COMPLETE.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
        this.currentRecipe = null;
        this.processingProgress = 0;
        this.isProcessing = false;
        this.m_6596_();
    }

    private CustomEnergyStorage createEnergyStorage() {
        return new CustomEnergyStorage(this.getMaxEnergy(), this.getMaxEnergy()){

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                int rc = super.receiveEnergy(maxReceive, simulate);
                if (rc > 0 && !simulate) {
                    SpatialCrafterBlockEntity.this.m_6596_();
                }
                return rc;
            }
        };
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.saveClientData(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag != null) {
            this.loadClientData(tag);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
    }

    private void saveClientData(CompoundTag tag) {
        tag.m_128365_("Energy", this.energy.serializeNBT());
        tag.m_128379_("isDisabled", this.isDisabled);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128379_("isProcessing", this.isProcessing);
        tag.m_128405_("processingProgress", this.processingProgress);
        tag.m_128405_("size", this.size);
        if (this.currentRecipe != null) {
            tag.m_128359_("currentRecipe", this.currentRecipe.m_6423_().toString());
        }
    }

    private void loadClientData(CompoundTag tag) {
        ResourceLocation recipeId;
        if (tag.m_128441_("Energy")) {
            this.energy.deserializeNBT(tag.m_128423_("Energy"));
        }
        this.isDisabled = tag.m_128471_("isDisabled");
        if (tag.m_128441_("Inventory")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        }
        this.isProcessing = tag.m_128471_("isProcessing");
        this.processingProgress = tag.m_128451_("processingProgress");
        int n = this.size = tag.m_128441_("size") ? this.size(tag.m_128451_("size")) : 5;
        if (tag.m_128441_("currentRecipe") && this.f_58857_ != null && (recipeId = ResourceLocation.m_135820_((String)tag.m_128461_("currentRecipe"))) != null) {
            this.currentRecipe = this.f_58857_.m_7465_().m_44043_(recipeId).filter(recipe -> recipe instanceof SpatialCrafterRecipe).map(recipe -> (SpatialCrafterRecipe)recipe).orElse(null);
        }
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Energy")) {
            this.energy.deserializeNBT(tag.m_128423_("Energy"));
        }
        this.isDisabled = tag.m_128471_("isDisabled");
        if (tag.m_128441_("Inventory")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        }
        this.isProcessing = tag.m_128471_("isProcessing");
        this.processingProgress = tag.m_128451_("processingProgress");
        int n = this.size = tag.m_128441_("size") ? this.size(tag.m_128451_("size")) : 5;
        if (tag.m_128441_("currentRecipe")) {
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)tag.m_128461_("currentRecipe"));
        }
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("Energy", this.energy.serializeNBT());
        tag.m_128379_("isDisabled", this.isDisabled);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128379_("isProcessing", this.isProcessing);
        tag.m_128405_("processingProgress", this.processingProgress);
        tag.m_128405_("size", this.size);
        if (this.currentRecipe != null) {
            tag.m_128359_("currentRecipe", this.currentRecipe.m_6423_().toString());
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getMaxEnergy() {
        return (Integer)CommonConfig.GENERAL.recipe_energy_multiplier.get() * 100000;
    }

    public void tickClient() {
    }

    public int getProcessingProgress() {
        return this.processingProgress;
    }

    public int getMaxProgress() {
        return this.currentRecipe != null ? (int)((double)this.currentRecipe.getProcessingTime() * (Double)CommonConfig.GENERAL.recipe_time_multiplier.get()) : 0;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public SpatialCrafterRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int newSize) {
        this.size = this.size(newSize);
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public AABB getScanArea() {
        if (this.f_58857_ == null) {
            return new AABB((double)(this.f_58858_.m_123341_() - this.size), (double)this.f_58858_.m_123342_(), (double)(this.f_58858_.m_123343_() - this.size), (double)(this.f_58858_.m_123341_() + this.size + 1), (double)(this.f_58858_.m_123342_() + this.size + 1), (double)(this.f_58858_.m_123343_() + this.size + 1));
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockPos centerPos = this.f_58858_.m_5484_(facing.m_122424_(), 1);
        return switch (facing) {
            case Direction.NORTH -> new AABB((double)(centerPos.m_123341_() - this.size), (double)this.f_58858_.m_123342_(), (double)centerPos.m_123343_(), (double)(centerPos.m_123341_() + this.size), (double)(this.f_58858_.m_123342_() + this.size * 2), (double)(centerPos.m_123343_() + this.size * 2));
            case Direction.SOUTH -> new AABB((double)(centerPos.m_123341_() - this.size), (double)this.f_58858_.m_123342_(), (double)centerPos.m_123343_(), (double)(centerPos.m_123341_() + this.size), (double)(this.f_58858_.m_123342_() + this.size * 2), (double)(centerPos.m_123343_() - this.size * 2));
            case Direction.EAST -> new AABB((double)centerPos.m_123341_(), (double)this.f_58858_.m_123342_(), (double)(centerPos.m_123343_() - this.size), (double)(centerPos.m_123341_() - this.size * 2), (double)(this.f_58858_.m_123342_() + this.size * 2), (double)(centerPos.m_123343_() + this.size));
            case Direction.WEST -> new AABB((double)centerPos.m_123341_(), (double)this.f_58858_.m_123342_(), (double)(centerPos.m_123343_() - this.size), (double)(centerPos.m_123341_() + this.size * 2), (double)(this.f_58858_.m_123342_() + this.size * 2), (double)(centerPos.m_123343_() + this.size));
            default -> new AABB((double)(centerPos.m_123341_() - this.size + 1), (double)this.f_58858_.m_123342_(), (double)(centerPos.m_123343_() - this.size + 1), (double)(centerPos.m_123341_() + this.size) - 1.0001, (double)(this.f_58858_.m_123342_() + this.size * 2) - 1.0001, (double)(centerPos.m_123343_() + this.size) - 0.9999);
        };
    }
}

