/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import igentuman.spatialcrafter.util.MultiblockStructure;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class PreviewRenderer {
    private static float interpolatedAlpha = 0.5f;
    private static MultiblockStructure structure = null;
    private static final Minecraft mc = Minecraft.m_91087_();
    private static int height;
    private static int length;
    private static int width;
    private static BlockPos hit;
    private static float dir;
    private static float scale;
    private static float rotation;
    private static float rotationSpeed;
    private static float glowIntensity;
    private static boolean particlesEnabled;
    private static float particleIntensity;
    private static int particleTimer;

    public static void setStructure(MultiblockStructure structure) {
        PreviewRenderer.structure = structure;
    }

    public static float getRotation() {
        return rotation;
    }

    public static void setRotation(float angle) {
        rotation = angle % 360.0f;
    }

    public static void resetRotation() {
        rotation = 0.0f;
    }

    public static void setRotationSpeed(float speed) {
        rotationSpeed = speed;
    }

    public static float getRotationSpeed() {
        return rotationSpeed;
    }

    public static void setScale(float newScale) {
        scale = Math.max(0.1f, Math.min(2.0f, newScale));
    }

    public static float getScale() {
        return scale;
    }

    public static void setGlowIntensity(float intensity) {
        glowIntensity = Math.max(0.0f, Math.min(2.0f, intensity));
    }

    public static float getGlowIntensity() {
        return glowIntensity;
    }

    public static void setParticlesEnabled(boolean enabled) {
        particlesEnabled = enabled;
    }

    public static boolean areParticlesEnabled() {
        return particlesEnabled;
    }

    public static void setParticleIntensity(float intensity) {
        particleIntensity = Math.max(0.0f, Math.min(2.0f, intensity));
    }

    public static float getParticleIntensity() {
        return particleIntensity;
    }

    public static boolean renderPreview(Vec3 center, PoseStack poseStack, float partialTicks, int renderTick) {
        BlockPos pos = new BlockPos((int)center.m_7096_(), (int)center.m_7098_(), (int)center.m_7094_());
        return PreviewRenderer.renderPreview(pos, poseStack, partialTicks, renderTick);
    }

    public static boolean renderPreview(BlockPos center, PoseStack poseStack, float partialTicks, int renderTick) {
        if (structure == null) {
            return false;
        }
        poseStack.m_85836_();
        height = structure.getHeight();
        length = structure.getDepth();
        width = structure.getWidth();
        Vec3 cameraPos = PreviewRenderer.mc.f_91063_.m_109153_().m_90583_();
        rotation += rotationSpeed * partialTicks;
        if (rotation >= 360.0f) {
            rotation -= 360.0f;
        }
        poseStack.m_85837_((double)center.m_123341_() - cameraPos.f_82479_ + 0.5, (double)center.m_123342_() - cameraPos.f_82480_ + 0.25, (double)center.m_123343_() - cameraPos.f_82481_ + 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        float finalScale = 0.5f;
        poseStack.m_85841_(finalScale, finalScale, finalScale);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        PreviewRenderer.renderPreviewBlocks(poseStack, partialTicks);
        if (particlesEnabled) {
            PreviewRenderer.renderParticleEffects(center, partialTicks, renderTick);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
        return true;
    }

    private static void renderPreviewBlocks(PoseStack poseStack, float partialTicks) {
        ClientLevel world = PreviewRenderer.mc.f_91073_;
        if (world == null || structure == null) {
            return;
        }
        BlockRenderDispatcher blockRenderer = mc.m_91289_();
        if ((interpolatedAlpha += partialTicks * dir) >= 0.8f) {
            dir = -0.005f;
        }
        if (interpolatedAlpha <= 0.5f) {
            dir = 0.005f;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        Map<BlockPos, BlockState> blocks = structure.getBlocks();
        for (Map.Entry<BlockPos, BlockState> entry : blocks.entrySet()) {
            BlockPos structurePos = entry.getKey();
            BlockState blockState = entry.getValue();
            if (blockState.m_60795_()) continue;
            int xo = structurePos.m_123341_() - structure.getMinX();
            int yo = structurePos.m_123342_() - structure.getMinY();
            int zo = structurePos.m_123343_() - structure.getMinZ();
            double relativeX = (double)xo - ((double)width / 2.0 - 0.5);
            double relativeY = (double)yo - ((double)height / 2.0 - 0.5);
            double relativeZ = (double)zo - ((double)length / 2.0 - 0.5);
            poseStack.m_85836_();
            poseStack.m_85837_(relativeX, relativeY, relativeZ);
            try {
                PreviewRenderer.renderTranslucentBlock(blockState, poseStack, (MultiBufferSource)bufferSource, interpolatedAlpha);
            }
            catch (Exception e) {
                PreviewRenderer.renderSimpleCube(poseStack, (MultiBufferSource)bufferSource);
            }
            poseStack.m_85849_();
        }
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private static void renderTranslucentBlock(BlockState blockState, PoseStack poseStack, MultiBufferSource bufferSource, float alpha) {
        BlockRenderDispatcher blockRenderer = mc.m_91289_();
        BakedModel model = blockRenderer.m_110910_(blockState);
        RandomSource random = RandomSource.m_216335_((long)42L);
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110466_());
        for (Direction direction : Direction.values()) {
            List quads = model.m_213637_(blockState, direction, random);
            PreviewRenderer.renderQuadsWithAlpha(poseStack, buffer, quads, alpha, 0xF000F0, OverlayTexture.f_118083_);
        }
        List generalQuads = model.m_213637_(blockState, null, random);
        PreviewRenderer.renderQuadsWithAlpha(poseStack, buffer, generalQuads, alpha, 0xF000F0, OverlayTexture.f_118083_);
    }

    private static void renderQuadsWithAlpha(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, float alpha, int light, int overlay) {
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        for (BakedQuad quad : quads) {
            int[] vertices = quad.m_111303_();
            Vec3 quadNormal = new Vec3((double)quad.m_111306_().m_122436_().m_123341_(), (double)quad.m_111306_().m_122436_().m_123342_(), (double)quad.m_111306_().m_122436_().m_123343_());
            for (int i = 0; i < 4; ++i) {
                int vertexIndex = i * 8;
                float x = Float.intBitsToFloat(vertices[vertexIndex]);
                float y = Float.intBitsToFloat(vertices[vertexIndex + 1]);
                float z = Float.intBitsToFloat(vertices[vertexIndex + 2]);
                int color = vertices[vertexIndex + 3];
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                float u = Float.intBitsToFloat(vertices[vertexIndex + 4]);
                float v = Float.intBitsToFloat(vertices[vertexIndex + 5]);
                buffer.m_252986_(pose, x, y, z).m_85950_(r, g, b, alpha).m_7421_(u, v).m_86008_(overlay).m_85969_(light).m_252939_(normal, (float)quadNormal.f_82479_, (float)quadNormal.f_82480_, (float)quadNormal.f_82481_).m_5752_();
            }
        }
    }

    private static void renderSimpleCube(PoseStack poseStack, MultiBufferSource bufferSource) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float alpha = interpolatedAlpha;
        float r = 0.8f;
        float g = 0.8f;
        float b = 0.8f;
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        tessellator.m_85914_();
    }

    private static void renderParticleEffects(BlockPos center, float partialTicks, int renderTick) {
        ClientLevel world = PreviewRenderer.mc.f_91073_;
        if (world == null || structure == null) {
            return;
        }
        double structureWidth = (float)width * 0.5f;
        double structureHeight = (float)height * 0.5f;
        double structureLength = (float)length * 0.5f;
        if (++particleTimer % 10 == 0) {
            PreviewRenderer.spawnMagicalSparkles((Level)world, center, structureWidth, structureHeight, structureLength);
        }
        if (particleTimer % 5 == 0) {
            // empty if block
        }
        if (particleTimer % 4 == 0) {
            PreviewRenderer.spawnConstructionParticles((Level)world, center);
        }
    }

    private static void spawnMagicalSparkles(Level world, BlockPos center, double width, double height, double length) {
        for (int i = 0; i < (int)(5.0f * particleIntensity); ++i) {
            double x = (double)center.m_123341_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * (width + 2.0);
            double y = (double)center.m_123342_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * (height + 2.0);
            double z = (double)center.m_123343_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * (length + 2.0);
            double velX = (world.f_46441_.m_188500_() - 0.5) * 0.02;
            double velY = world.f_46441_.m_188500_() * 0.05 + 0.01;
            double velZ = (world.f_46441_.m_188500_() - 0.5) * 0.02;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, velX, velY, velZ);
        }
    }

    private static void spawnEnergyOrbs(Level world, BlockPos center, double width, double height, double length, int renderTick) {
        int numOrbs = (int)(3.0f * particleIntensity);
        for (int i = 0; i < numOrbs; ++i) {
            float angle = ((float)renderTick * 0.05f + (float)i * (360.0f / (float)numOrbs)) % 360.0f;
            float radius = (float)(Math.max(width, length) + 1.5);
            double x = (double)center.m_123341_() + 0.5 + Math.cos(Math.toRadians(angle)) * (double)radius;
            double y = (double)center.m_123342_() + 0.5 + Math.sin((float)renderTick * 0.02f + (float)i) * height * 0.5;
            double z = (double)center.m_123343_() + 0.5 + Math.sin(Math.toRadians(angle)) * (double)radius;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, y, z, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 0.0, 0.01, 0.0);
        }
    }

    private static void spawnFloatingRunes(Level world, BlockPos center, double width, double height, double length) {
        int numRunes = (int)(2.0f * particleIntensity);
        for (int i = 0; i < numRunes; ++i) {
            double x = (double)center.m_123341_() + 0.5 + (world.f_46441_.m_188499_() ? width + 1.0 : -width - 1.0);
            double y = (double)center.m_123342_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * height;
            double z = (double)center.m_123343_() + 0.5 + (world.f_46441_.m_188499_() ? length + 1.0 : -length - 1.0);
            double velY = 0.02;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123809_, x, y, z, 0.0, velY, 0.0);
        }
    }

    private static void spawnConstructionParticles(Level world, BlockPos center) {
        Map<BlockPos, BlockState> blocks = structure.getBlocks();
        int particleCount = 0;
        int maxParticles = (int)(10.0f * particleIntensity);
        for (Map.Entry<BlockPos, BlockState> entry : blocks.entrySet()) {
            if (particleCount >= maxParticles) break;
            BlockPos structurePos = entry.getKey();
            BlockState blockState = entry.getValue();
            if (blockState.m_60795_() || world.f_46441_.m_188501_() > 0.1f * particleIntensity) continue;
            int xo = structurePos.m_123341_() - structure.getMinX();
            int yo = structurePos.m_123342_() - structure.getMinY();
            int zo = structurePos.m_123343_() - structure.getMinZ();
            double relativeX = (double)xo - ((double)width / 2.0 - 0.5);
            double relativeY = (double)yo - ((double)height / 2.0 - 0.5);
            double relativeZ = (double)zo - ((double)length / 2.0 - 0.5);
            double worldX = (double)center.m_123341_() + 0.5 + relativeX;
            double worldY = (double)center.m_123342_() + 0.5 + relativeY;
            double worldZ = (double)center.m_123343_() + 0.5 + relativeZ;
            float r = 0.3f + world.f_46441_.m_188501_() * 0.4f;
            float g = 0.6f + world.f_46441_.m_188501_() * 0.4f;
            float b = 1.0f;
            DustParticleOptions dustOptions = new DustParticleOptions(new Vector3f(r, g, b), 1.0f);
            world.m_7106_((ParticleOptions)dustOptions, worldX += (world.f_46441_.m_188500_() - 0.5) * 0.8, worldY += (world.f_46441_.m_188500_() - 0.5) * 0.8, worldZ += (world.f_46441_.m_188500_() - 0.5) * 0.8, 0.0, 0.02, 0.0);
            ++particleCount;
        }
    }

    static {
        dir = 0.005f;
        scale = 1.0f;
        rotation = 0.0f;
        rotationSpeed = 2.0f;
        glowIntensity = 1.0f;
        particlesEnabled = true;
        particleIntensity = 0.5f;
        particleTimer = 0;
    }
}

