/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import igentuman.spatialcrafter.block.SpatialCrafterBlockEntity;
import igentuman.spatialcrafter.client.PreviewRenderer;
import igentuman.spatialcrafter.recipe.SpatialCrafterRecipe;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="spatialcrafter", value={Dist.CLIENT})
public class SpatialCrafterOverlayHandler {
    public static final CopyOnWriteArrayList<BlockPos> spatialCrafterBlocks = new CopyOnWriteArrayList();

    @SubscribeEvent
    public static void onRenderWorldEvent(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_9236_() == null) {
            return;
        }
        Level level = player.m_9236_();
        if (!level.f_46443_) {
            return;
        }
        for (BlockPos pos : spatialCrafterBlocks) {
            BlockEntity be = level.m_7702_(pos);
            if (!(be instanceof SpatialCrafterBlockEntity)) continue;
            SpatialCrafterBlockEntity spatialCrafter = (SpatialCrafterBlockEntity)be;
            if (spatialCrafter.isDisabled) continue;
            AABB scanArea = spatialCrafter.getScanArea();
            float alpha = 0.125f;
            SpatialCrafterRecipe currentRecipe = spatialCrafter.getCurrentRecipe();
            if (currentRecipe instanceof SpatialCrafterRecipe && spatialCrafter.isProcessing()) {
                PreviewRenderer.setStructure(currentRecipe.getStructure());
                PreviewRenderer.renderPreview(scanArea.m_82399_(), event.getPoseStack(), event.getPartialTick(), event.getRenderTick());
                alpha = 0.065f;
            }
            scanArea = scanArea.m_165891_((double)((int)scanArea.f_82291_) + 1.0001).m_165880_((double)((int)scanArea.f_82288_) - 1.0E-4).m_165893_((double)((int)scanArea.f_82292_) + 1.0001).m_165887_((double)((int)scanArea.f_82289_) - 1.0E-4).m_165895_((double)((int)scanArea.f_82293_) + 1.0001).m_165889_((double)((int)scanArea.f_82290_) - 1.0E-4);
            SpatialCrafterOverlayHandler.renderFilledBox(event.getPoseStack(), scanArea, 0.2f, 0.8f, 1.0f, alpha);
        }
    }

    public static void addSpatialCrafterBlock(BlockPos pos) {
        if (!spatialCrafterBlocks.contains(pos)) {
            spatialCrafterBlocks.add(pos);
        }
    }

    public static void removeSpatialCrafterBlock(BlockPos pos) {
        spatialCrafterBlocks.remove(pos);
    }

    public static void renderFilledBox(PoseStack poseStack, AABB box, float r, float g, float b, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.disableCull();
        Vec3 cam = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double camX = cam.f_82479_;
        double camY = cam.f_82480_;
        double camZ = cam.f_82481_;
        poseStack.m_85836_();
        poseStack.m_85837_(-camX, -camY, -camZ);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float x1 = (float)box.f_82288_;
        float y1 = (float)box.f_82289_;
        float z1 = (float)box.f_82290_;
        float x2 = (float)box.f_82291_;
        float y2 = (float)box.f_82292_;
        float z2 = (float)box.f_82293_;
        float offset = 5.0E-4f;
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1 + offset, y1 + offset, z1 + offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1 + offset, y1 + offset, z2 - offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2 - offset, y1 + offset, z2 - offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2 - offset, y1 + offset, z1 + offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1 + offset, y2 - offset, z1 + offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2 - offset, y2 - offset, z1 + offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2 - offset, y2 - offset, z2 - offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1 + offset, y2 - offset, z2 - offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1 + offset, y1 + offset, z1 + offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2 - offset, y1 + offset, z1 + offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2 - offset, y2 - offset, z1 + offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1 + offset, y2 - offset, z1 + offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2 - offset, y1 + offset, z2 - offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1 + offset, y1 + offset, z2 - offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1 + offset, y2 - offset, z2 - offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2 - offset, y2 - offset, z2 - offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1 + offset, y1 + offset, z2 - offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1 + offset, y1 + offset, z1 + offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1 + offset, y2 - offset, z1 + offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1 + offset, y2 - offset, z2 - offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2 - offset, y1 + offset, z1 + offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2 - offset, y1 + offset, z2 - offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2 - offset, y2 - offset, z2 - offset).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2 - offset, y2 - offset, z1 + offset).m_85950_(r, g, b, alpha).m_5752_();
        tesselator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }
}

