/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.client;

import igentuman.spatialcrafter.Main;
import igentuman.spatialcrafter.container.SpatialCrafterContainer;
import igentuman.spatialcrafter.network.NetworkHandler;
import igentuman.spatialcrafter.network.SizeChangePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SpatialCrafterScreen
extends AbstractContainerScreen<SpatialCrafterContainer> {
    private final ResourceLocation GUI = Main.rl("textures/gui/spatial_crafter.png");
    private Button decreaseSizeButton;
    private Button increaseSizeButton;

    public SpatialCrafterScreen(SpatialCrafterContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.f_97726_ = 180;
        this.f_97727_ = 162;
    }

    public void m_7286_(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_280273_(graphics);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(this.GUI, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
        this.m_280072_(graphics, pMouseX, pMouseY);
        this.drawEnergyBar(graphics);
    }

    protected void m_7856_() {
        super.m_7856_();
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        this.decreaseSizeButton = Button.m_253074_((Component)Component.m_237115_((String)"button.spatialcrafter.size_decrease"), button -> {
            int currentSize = ((SpatialCrafterContainer)this.f_97732_).getSize();
            if (currentSize > 1) {
                NetworkHandler.INSTANCE.sendToServer((Object)new SizeChangePacket(((SpatialCrafterContainer)this.f_97732_).getBlockEntity().m_58899_(), currentSize - 1));
            }
        }).m_252987_(relX + 10, relY + 50, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.spatialcrafter.decrease_size"))).m_253136_();
        this.increaseSizeButton = Button.m_253074_((Component)Component.m_237115_((String)"button.spatialcrafter.size_increase"), button -> {
            int currentSize = ((SpatialCrafterContainer)this.f_97732_).getSize();
            if (currentSize < 27) {
                NetworkHandler.INSTANCE.sendToServer((Object)new SizeChangePacket(((SpatialCrafterContainer)this.f_97732_).getBlockEntity().m_58899_(), currentSize + 1));
            }
        }).m_252987_(relX + 150, relY + 50, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.spatialcrafter.increase_size"))).m_253136_();
        this.m_142416_((GuiEventListener)this.decreaseSizeButton);
        this.m_142416_((GuiEventListener)this.increaseSizeButton);
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.decreaseSizeButton != null && this.increaseSizeButton != null) {
            int currentSize = ((SpatialCrafterContainer)this.f_97732_).getSize();
            this.decreaseSizeButton.f_93623_ = currentSize > 1;
            this.increaseSizeButton.f_93623_ = currentSize < 27;
        }
    }

    public void drawEnergyBar(GuiGraphics graphics) {
        graphics.m_280218_(this.GUI, this.getGuiLeft() + 4, this.getGuiTop() + 151, 1, 171, ((SpatialCrafterContainer)this.f_97732_).getEnergyScaled(172), 7);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280137_(Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"gui.spatialcrafter.spatial_crafter", (Object[])new Object[0]), this.f_97726_ / 2, 4, 0xFFFFFF);
        MutableComponent sizeText = Component.m_237110_((String)"gui.spatialcrafter.size", (Object[])new Object[]{((SpatialCrafterContainer)this.f_97732_).getSize()});
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)sizeText, this.f_97726_ / 2, 55, 0xFFFFFF);
        if (((SpatialCrafterContainer)this.f_97732_).isProcessing()) {
            int progress = ((SpatialCrafterContainer)this.f_97732_).getProcessingProgress();
            int maxProgress = ((SpatialCrafterContainer)this.f_97732_).getMaxProgress();
            int percentage = maxProgress > 0 ? progress * 100 / maxProgress : 0;
            MutableComponent progressText = Component.m_237110_((String)"gui.spatialcrafter.progress", (Object[])new Object[]{percentage});
            graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)progressText, this.f_97726_ / 2, 41, 65280);
        }
        if (((SpatialCrafterContainer)this.f_97732_).isDisabled()) {
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.spatialcrafter.disabled"), 10, 85, 0xFFFFFF);
        }
    }

    public void m_280072_(GuiGraphics graphics, int x, int y) {
        if (x > this.getGuiLeft() + 4 && x < this.getGuiLeft() + 175 && y > this.getGuiTop() + 150 && y < this.getGuiTop() + 160) {
            MutableComponent textComponent = Component.m_237110_((String)"gui.spatialcrafter.energy.info", (Object[])new Object[]{((SpatialCrafterContainer)this.f_97732_).getEnergy(), ((SpatialCrafterContainer)this.f_97732_).getMaxEnergy()});
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)textComponent, x, y);
        }
        super.m_280072_(graphics, x, y);
    }
}

