/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.container;

import igentuman.spatialcrafter.Setup;
import igentuman.spatialcrafter.block.SpatialCrafterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SpatialCrafterContainer
extends AbstractContainerMenu {
    private SpatialCrafterBlockEntity blockEntity;
    private Player playerEntity;
    private final IItemHandler itemHandler;

    public SpatialCrafterContainer(int windowId, BlockPos pos, Inventory playerInventory, Player player) {
        super((MenuType)Setup.SPATIAL_CRAFTER_CONTAINER.get(), windowId);
        this.blockEntity = (SpatialCrafterBlockEntity)player.m_20193_().m_7702_(pos);
        this.playerEntity = player;
        this.itemHandler = (IItemHandler)this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (this.itemHandler != null) {
            this.addCrafterInventory();
        }
        this.addPlayerInventory(this.playerEntity.m_150109_());
        this.addPlayerHotbar(this.playerEntity.m_150109_());
    }

    private void addCrafterInventory() {
        int index = -1;
        for (int row = 0; row < 5; ++row) {
            this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, ++index, 46 + 18 * row, 21));
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int yOffset = 72;
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 10 + l * 18, yOffset + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        int yOffset = 130;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 10 + i * 18, yOffset));
        }
    }

    public int getEnergyScaled(int scale) {
        return (int)((float)scale * ((float)this.blockEntity.getEnergy() / (float)this.blockEntity.getMaxEnergy()));
    }

    public boolean isDisabled() {
        return this.blockEntity.isDisabled;
    }

    public int getEnergy() {
        return this.blockEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        return null;
    }

    public boolean m_6875_(Player playerIn) {
        return SpatialCrafterContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)Setup.SPATIAL_CRAFTER_BLOCK.get()));
    }

    public void checkboxClicked(int id, int val) {
    }

    public int getMaxEnergy() {
        return this.blockEntity.getMaxEnergy();
    }

    public int getSize() {
        return this.blockEntity.getSize();
    }

    public SpatialCrafterBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getProcessingProgress() {
        return this.blockEntity.getProcessingProgress();
    }

    public int getMaxProgress() {
        return this.blockEntity.getMaxProgress();
    }

    public boolean isProcessing() {
        return this.blockEntity.isProcessing();
    }
}

