/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.integration.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import igentuman.spatialcrafter.integration.emi.MultiblockStructureEmiCategory;
import igentuman.spatialcrafter.integration.emi.MultiblockStructureEmiRecipe;
import igentuman.spatialcrafter.recipe.SpatialCrafterRecipe;
import igentuman.spatialcrafter.recipe.SpatialCrafterRecipeManager;
import igentuman.spatialcrafter.util.MultiblocksProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.Level;

@EmiEntrypoint
public class EMIPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.addCategory((EmiRecipeCategory)MultiblockStructureEmiCategory.INSTANCE);
        List<MultiblockStructureEmiRecipe> multiblockRecipes = this.loadMultiblockStructures();
        for (MultiblockStructureEmiRecipe recipe : multiblockRecipes) {
            registry.addRecipe((EmiRecipe)recipe);
        }
    }

    private List<MultiblockStructureEmiRecipe> loadMultiblockStructures() {
        ArrayList<MultiblockStructureEmiRecipe> recipes = new ArrayList<MultiblockStructureEmiRecipe>();
        MultiblocksProvider.getStructures().stream().map(structure -> new MultiblockStructureEmiRecipe(structure.getId(), structure.getStructureNbt(), structure.getName(), null)).forEach(recipes::add);
        if (Minecraft.m_91087_().f_91073_ != null) {
            List<SpatialCrafterRecipe> spatialRecipes = SpatialCrafterRecipeManager.getAllRecipes((Level)Minecraft.m_91087_().f_91073_);
            for (SpatialCrafterRecipe spatialRecipe : spatialRecipes) {
                MultiblocksProvider.getStructures().stream().filter(structure -> structure.getId().equals((Object)spatialRecipe.getMultiblockId())).findFirst().ifPresent(structure -> {
                    recipes.removeIf(recipe -> recipe.getId().equals((Object)structure.getId()));
                    recipes.add(new MultiblockStructureEmiRecipe(structure.getId(), structure.getStructureNbt(), structure.getName(), spatialRecipe));
                });
            }
        }
        return recipes;
    }
}

