/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.integration.emi;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import igentuman.spatialcrafter.Setup;
import igentuman.spatialcrafter.integration.emi.MultiblockStructureEmiCategory;
import igentuman.spatialcrafter.recipe.SpatialCrafterRecipe;
import igentuman.spatialcrafter.util.MultiblockStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class MultiblockStructureEmiRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final CompoundTag structureNbt;
    private final String name;
    private final MultiblockStructure structure;
    private final List<EmiStack> outputs;
    private final List<EmiIngredient> inputs;
    private final SpatialCrafterRecipe spatialRecipe;
    public int currentLayer = 0;

    public MultiblockStructureEmiRecipe(ResourceLocation id, CompoundTag structureNbt, String name, SpatialCrafterRecipe spatialRecipe) {
        this.id = id;
        this.structureNbt = structureNbt;
        this.name = name;
        this.spatialRecipe = spatialRecipe;
        this.structure = new MultiblockStructure(structureNbt);
        this.currentLayer = this.structure.getMaxY();
        this.outputs = new ArrayList<EmiStack>();
        this.inputs = new ArrayList<EmiIngredient>();
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (BlockPos pos : this.structure.getBlocks().keySet()) {
            Block block = this.structure.getBlocks().get(pos).m_60734_();
            if (blocks.contains(block)) continue;
            blocks.add(block);
            this.inputs.add(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)block)})));
        }
        for (Block block : blocks) {
            int count = 0;
            for (BlockState blockState : this.structure.getBlocks().values()) {
                if (blockState.m_60734_() != block) continue;
                ++count;
            }
            EmiStack blockStack = EmiStack.of((ItemStack)new ItemStack((ItemLike)block, count));
            this.outputs.add(blockStack);
        }
        if (spatialRecipe != null && !spatialRecipe.getOutputs().isEmpty()) {
            for (ItemStack output : spatialRecipe.getOutputs()) {
                this.outputs.add(EmiStack.of((ItemStack)output));
            }
        }
    }

    public EmiRecipeCategory getCategory() {
        return MultiblockStructureEmiCategory.INSTANCE;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Setup.SPATIAL_CRAFTER_BLOCK.get()})));
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 176;
    }

    public int getDisplayHeight() {
        return 158;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addText((Component)Component.m_237115_((String)this.name), 5, 2, -1, false);
        int slotIndex = 0;
        for (EmiStack output : this.outputs) {
            if (output.isEmpty() || slotIndex >= 30) continue;
            SlotWidget slot = widgets.addSlot((EmiIngredient)output, 5 + slotIndex % 4 * 18, 12 + slotIndex / 4 * 18);
            slot.recipeContext((EmiRecipe)this);
            ++slotIndex;
        }
        if (this.spatialRecipe != null) {
            int yOffset = 90;
            if (this.spatialRecipe.getProcessingTime() > 0) {
                widgets.addText((Component)Component.m_237113_((String)("Time: " + this.spatialRecipe.getProcessingTime() + " ticks")), 5, yOffset, -1, false);
                yOffset += 10;
            }
            if (this.spatialRecipe.getEnergyConsumption() > 0) {
                widgets.addText((Component)Component.m_237113_((String)("Energy: " + this.spatialRecipe.getEnergyConsumption() + " FE")), 5, yOffset, -1, false);
                yOffset += 10;
            }
        }
        widgets.add((Widget)new MultiblockRenderWidget(50, 10, 120, 80, this));
    }

    public String getName() {
        return this.name;
    }

    public MultiblockStructure getStructure() {
        return this.structure;
    }

    public SpatialCrafterRecipe getSpatialRecipe() {
        return this.spatialRecipe;
    }

    public void slice() {
        if (this.structure.getMaxY() < this.currentLayer) {
            this.currentLayer = this.structure.getMaxY();
        }
        --this.currentLayer;
        if (this.currentLayer < this.structure.getMinY()) {
            this.currentLayer = this.structure.getMaxY();
        }
    }

    private void renderMultiblock(GuiGraphics graphics, MultiblockStructure structure, int maxLayer, int x, int y, int width, int height) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, 100.0f);
        float scale = 50.0f;
        graphics.m_280168_().m_85841_(scale, -scale, scale);
        graphics.m_280168_().m_252781_(new Quaternionf().rotationX((float)Math.toRadians(15.0)));
        graphics.m_280168_().m_252781_(new Quaternionf().rotationY((float)Math.toRadians(45.0)));
        long time = System.currentTimeMillis();
        float angle = (float)(time % 20000L) / 20000.0f * ((float)Math.PI * 2);
        graphics.m_280168_().m_252781_(new Quaternionf().rotationY(angle * 0.5f));
        this.renderStructureBlocks(graphics.m_280168_(), structure, maxLayer);
        graphics.m_280168_().m_85849_();
    }

    private void renderStructureBlocks(PoseStack stack, MultiblockStructure structure, int maxLayer) {
        Minecraft minecraft = Minecraft.m_91087_();
        BlockRenderDispatcher blockRenderer = minecraft.m_91289_();
        Map<BlockPos, BlockState> blocks = structure.getBlocks();
        if (blocks.isEmpty()) {
            return;
        }
        int structureWidth = structure.getWidth();
        int structureHeight = structure.getHeight();
        int depth = structure.getDepth();
        float scale = 1.0f / (float)Math.max(Math.max(structureWidth, structureHeight), depth);
        stack.m_85841_(scale, scale, scale);
        float centerX = (float)structure.getMinX() + (float)structureWidth / 2.0f;
        float centerY = (float)structure.getMinY() + (float)structureHeight / 2.0f;
        float centerZ = (float)structure.getMinZ() + (float)depth / 2.0f;
        stack.m_252880_(-centerX, -centerY, -centerZ);
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        for (Map.Entry<BlockPos, BlockState> entry : blocks.entrySet()) {
            BlockPos pos = entry.getKey();
            if (pos.m_123342_() > maxLayer) continue;
            BlockState state = entry.getValue();
            stack.m_85836_();
            stack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            ModelData modelData = ModelData.EMPTY;
            blockRenderer.renderSingleBlock(state, stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, modelData, null);
            stack.m_85849_();
        }
        bufferSource.m_109911_();
    }

    private static class MultiblockRenderWidget
    extends Widget {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final MultiblockStructureEmiRecipe recipe;

        public MultiblockRenderWidget(int x, int y, int width, int height, MultiblockStructureEmiRecipe recipe) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.recipe = recipe;
        }

        public Bounds getBounds() {
            return new Bounds(this.x, this.y, this.width, this.height);
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.recipe.renderMultiblock(graphics, this.recipe.structure, this.recipe.currentLayer, this.x, this.y, this.width, this.height);
        }

        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            if (button == 1) {
                this.recipe.slice();
                return true;
            }
            return false;
        }
    }
}

