/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.integration.jei;

import igentuman.spatialcrafter.Main;
import igentuman.spatialcrafter.integration.jei.MultiblockStructureCategory;
import igentuman.spatialcrafter.integration.jei.MultiblockStructureRecipe;
import igentuman.spatialcrafter.recipe.SpatialCrafterRecipe;
import igentuman.spatialcrafter.recipe.SpatialCrafterRecipeManager;
import igentuman.spatialcrafter.util.MultiblocksProvider;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private IIngredientManager ingredientManager;

    public ResourceLocation getPluginUid() {
        return Main.rl("jei_plugin");
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MultiblockStructureCategory(registration.getJeiHelpers().getGuiHelper())});
        this.ingredientManager = registration.getJeiHelpers().getIngredientManager();
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<MultiblockStructureRecipe> multiblockRecipes = this.loadMultiblockStructures();
        registration.addRecipes(MultiblockStructureCategory.TYPE, multiblockRecipes);
    }

    private List<MultiblockStructureRecipe> loadMultiblockStructures() {
        ArrayList<MultiblockStructureRecipe> recipes = new ArrayList<MultiblockStructureRecipe>();
        MultiblocksProvider.getStructures().stream().map(structure -> new MultiblockStructureRecipe(structure.getId(), structure.getStructureNbt(), structure.getName(), this.ingredientManager)).forEach(recipes::add);
        if (Minecraft.m_91087_().f_91073_ != null) {
            List<SpatialCrafterRecipe> spatialRecipes = SpatialCrafterRecipeManager.getAllRecipes((Level)Minecraft.m_91087_().f_91073_);
            block0: for (SpatialCrafterRecipe spatialRecipe : spatialRecipes) {
                for (MultiblockStructureRecipe multiblockRecipe : recipes) {
                    if (!multiblockRecipe.getId().equals((Object)spatialRecipe.getMultiblockId())) continue;
                    multiblockRecipe.setSpatialRecipe(spatialRecipe);
                    continue block0;
                }
            }
        }
        return recipes;
    }
}

