/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.integration.jei;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import igentuman.spatialcrafter.CommonConfig;
import igentuman.spatialcrafter.Setup;
import igentuman.spatialcrafter.integration.jei.IngredientsButton;
import igentuman.spatialcrafter.integration.jei.MultiblockStructureRecipe;
import igentuman.spatialcrafter.recipe.SpatialCrafterRecipe;
import igentuman.spatialcrafter.util.MultiblockStructure;
import igentuman.spatialcrafter.util.TextUtils;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.lwjgl.glfw.GLFW;

public class MultiblockStructureCategory
implements IRecipeCategory<MultiblockStructureRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("spatialcrafter", "multiblock_structure");
    public static final RecipeType<MultiblockStructureRecipe> TYPE = RecipeType.create((String)"spatialcrafter", (String)"multiblock_structure", MultiblockStructureRecipe.class);
    private boolean isMouseDragging = false;
    private double lastMouseX = 0.0;
    private float manualRotationAngle = 0.0f;
    private long mouseReleaseTime = 0L;
    private float autoRotationSpeed = 0.31415927f;
    private double lastMouseY = 0.0;
    private float manualTiltAmount = 0.2f;
    private boolean sliceMode = false;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;
    private final MultiblockRenderer renderer;
    private IngredientsButton ingredientsButton;

    public MultiblockStructureCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(180, 140);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Setup.SPATIAL_CRAFTER_ITEM.get()));
        this.title = Component.m_237115_((String)"jei.category.spatialcrafter.multiblock_structure");
        this.renderer = new MultiblockRenderer();
    }

    public RecipeType<MultiblockStructureRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MultiblockStructureRecipe recipe, IFocusGroup focuses) {
        builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addItemLike((ItemLike)Setup.SPATIAL_CRAFTER_ITEM.get());
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemLike((ItemLike)Setup.SPATIAL_CRAFTER_ITEM.get());
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addIngredients(recipe.getIngredients());
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients(recipe.getIngredients());
        if (recipe.hasSpatialRecipe()) {
            List<ItemStack> recipeOutputs = recipe.getRecipeOutputs();
            for (int i = 0; i < recipeOutputs.size() && i < 56; ++i) {
                int x = 120 + i % 2 * 18;
                int y = 20 + i / 2 * 18;
                builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(recipeOutputs.get(i));
            }
        }
        this.ingredientsButton = IngredientsButton.create(recipe);
        this.ingredientsButton.updateBounds(new Rect2i(5, 15, 10, 10));
    }

    public void draw(MultiblockStructureRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        float angle;
        long window;
        Font font = Minecraft.m_91087_().f_91062_;
        this.ingredientsButton.recipe = recipe;
        this.ingredientsButton.draw(graphics, 5, 15, 1.0f);
        if (this.ingredientsButton.isMouseOver(mouseX, mouseY)) {
            this.ingredientsButton.drawTooltips(graphics, (int)mouseX, (int)mouseY);
        }
        graphics.m_280430_(font, (Component)TextUtils.__(recipe.getName(), new Object[0]), 5, 0, -1);
        if (recipe.hasSpatialRecipe()) {
            graphics.m_280488_(font, Component.m_237115_((String)"jei.spatialcrafter.outputs").getString(), 120, 10, -1);
            int processingTime = recipe.getProcessingTime();
            int energyConsumption = recipe.getEnergyConsumption() * (Integer)CommonConfig.GENERAL.recipe_energy_multiplier.get();
            if (processingTime > 0) {
                MutableComponent timeText = Component.m_237110_((String)"jei.spatialcrafter.processing_time", (Object[])new Object[]{Float.valueOf((float)processingTime / 20.0f)});
                graphics.m_280488_(font, timeText.getString(), 5, 125, -1);
            }
            if (energyConsumption > 0) {
                MutableComponent energyText = Component.m_237110_((String)"jei.spatialcrafter.energy_consumption", (Object[])new Object[]{TextUtils.scaledFormat(energyConsumption)});
                graphics.m_280488_(font, energyText.getString(), 90, 125, -1);
            }
        }
        boolean leftMouseDown = GLFW.glfwGetMouseButton((long)(window = Minecraft.m_91087_().m_91268_().m_85439_()), (int)0) == 1;
        long currentTime = System.currentTimeMillis();
        if (this.mouseReleaseTime == 0L) {
            this.mouseReleaseTime = currentTime;
        }
        if (this.isMouseDragging) {
            angle = this.manualRotationAngle;
        } else {
            float timeDiff = (float)(currentTime - this.mouseReleaseTime) / 1000.0f;
            angle = this.manualRotationAngle + timeDiff * this.autoRotationSpeed;
            if ((double)angle > Math.PI * 2) {
                this.manualRotationAngle = angle %= (float)Math.PI * 2;
                this.mouseReleaseTime = currentTime;
            }
        }
        if (leftMouseDown && !this.isMouseDragging && this.isMouseInRotationArea(mouseX, mouseY)) {
            this.isMouseDragging = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.manualRotationAngle = angle;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(80.0f, 75.0f, 100.0f);
        float scale = 65.0f;
        graphics.m_280168_().m_85841_(scale, -scale, scale);
        if (this.isMouseDragging && !leftMouseDown) {
            this.isMouseDragging = false;
            this.mouseReleaseTime = currentTime;
        }
        if (this.isMouseDragging) {
            float sensitivity = 0.02f;
            float delta = (float)(mouseX - this.lastMouseX) * sensitivity;
            this.manualRotationAngle += delta;
            float tiltSensitivity = 0.02f;
            float tiltDelta = (float)(mouseY - this.lastMouseY) * tiltSensitivity;
            this.manualTiltAmount += tiltDelta;
            this.manualTiltAmount = Math.max(-0.5f, Math.min(0.5f, this.manualTiltAmount));
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        }
        graphics.m_280168_().m_252781_(new Quaternionf().rotationY(angle));
        float xTilt = this.manualTiltAmount * (float)Math.cos(angle);
        float zTilt = this.manualTiltAmount * (float)Math.sin(angle);
        graphics.m_280168_().m_252781_(new Quaternionf().rotationX(xTilt));
        graphics.m_280168_().m_252781_(new Quaternionf().rotationZ(zTilt));
        if (this.sliceMode) {
            recipe.slice();
            this.sliceMode = false;
        }
        this.renderer.render(recipe.getStructure(), graphics.m_280168_(), recipe.currentLayer);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        for (SpatialCrafterRecipe.EntityOutput entity : recipe.getRecipeEntities()) {
            this.renderEntity(entity);
        }
        graphics.m_280168_().m_85849_();
    }

    private void renderEntity(SpatialCrafterRecipe.EntityOutput entityOutput) {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher entityRenderDispatcher = mc.m_91290_();
        if (mc.f_91073_ == null) {
            return;
        }
        Entity entity = entityOutput.getEntityType().m_20615_((Level)mc.f_91073_);
        if (entity == null) {
            return;
        }
        if (!entityOutput.getNbt().m_128456_()) {
            entity.m_20258_(entityOutput.getNbt());
        }
        BlockPos relativePos = entityOutput.getRelativePos();
        entity.m_6034_((double)relativePos.m_123341_(), (double)relativePos.m_123342_(), (double)relativePos.m_123343_());
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        poseStack.m_252880_(300.0f, 190.0f, 0.0f);
        poseStack.m_85841_(10.0f, -10.0f, 10.0f);
        poseStack.m_252781_(new Quaternionf().rotationX(0.5f));
        poseStack.m_252781_(new Quaternionf().rotationY((float)mc.f_91073_.m_46467_() * 0.05f));
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        try {
            entityRenderDispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0);
            bufferSource.m_109911_();
        }
        catch (Exception exception) {
            // empty catch block
        }
        poseStack.m_85849_();
    }

    public boolean handleInput(MultiblockStructureRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_().equals((Object)InputConstants.Type.MOUSE)) {
            this.mouseClicked(mouseX, mouseY, input.m_84873_());
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1 && this.isMouseInRotationArea(mouseX, mouseY)) {
            this.sliceMode = true;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isMouseDragging && button == 0) {
            float sensitivity = 0.01f;
            float delta = (float)(mouseX - this.lastMouseX) * sensitivity;
            this.manualRotationAngle += delta;
            this.lastMouseX = mouseX;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseDragging) {
            this.isMouseDragging = false;
            return true;
        }
        return false;
    }

    private boolean isMouseInRotationArea(double mouseX, double mouseY) {
        double centerX = 80.0;
        double centerY = 75.0;
        double radius = 50.0;
        return Math.pow(mouseX - centerX, 2.0) + Math.pow(mouseY - centerY, 2.0) <= Math.pow(radius, 2.0);
    }

    private static class MultiblockRenderer {
        private MultiblockRenderer() {
        }

        public void render(MultiblockStructure structure, PoseStack stack) {
            this.render(structure, stack, Integer.MAX_VALUE);
        }

        public void render(MultiblockStructure structure, PoseStack stack, int maxLayer) {
            Minecraft minecraft = Minecraft.m_91087_();
            BlockRenderDispatcher blockRenderer = minecraft.m_91289_();
            Map<BlockPos, BlockState> blocks = structure.getBlocks();
            if (blocks.isEmpty()) {
                return;
            }
            int width = structure.getWidth();
            int height = structure.getHeight();
            int depth = structure.getDepth();
            float scale = 1.0f / (float)Math.max(Math.max(width, height), depth);
            stack.m_85841_(scale, scale, scale);
            float centerX = (float)structure.getMinX() + (float)width / 2.0f;
            float centerY = (float)structure.getMinY() + (float)height / 2.0f;
            float centerZ = (float)structure.getMinZ() + (float)depth / 2.0f;
            stack.m_252880_(-centerX, -centerY, -centerZ);
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            RandomSource random = RandomSource.m_216327_();
            for (Map.Entry<BlockPos, BlockState> entry : blocks.entrySet()) {
                BlockPos pos = entry.getKey();
                if (pos.m_123342_() > maxLayer) continue;
                BlockState state = entry.getValue();
                stack.m_85836_();
                stack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                ModelData modelData = ModelData.EMPTY;
                BakedModel model = blockRenderer.m_110910_(state);
                try {
                    modelData = model.getModelData((BlockAndTintGetter)minecraft.f_91073_, pos, state, ModelData.EMPTY);
                }
                catch (Exception e) {
                    modelData = ModelData.EMPTY;
                }
                blockRenderer.renderSingleBlock(state, stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, modelData, null);
                stack.m_85849_();
            }
            bufferSource.m_109911_();
        }
    }
}

