/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.integration.jei;

import igentuman.spatialcrafter.recipe.SpatialCrafterRecipe;
import igentuman.spatialcrafter.util.MultiblockStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MultiblockStructureRecipe {
    private final ResourceLocation id;
    private final CompoundTag structureNbt;
    private final String name;
    private final MultiblockStructure structure;
    public int currentLayer = 0;
    public List<ItemStack> outputs = new ArrayList<ItemStack>();
    public List<ItemStack> structureIngredients = new ArrayList<ItemStack>();
    private IIngredientManager ingredientManager;
    private SpatialCrafterRecipe spatialRecipe;

    public MultiblockStructureRecipe(ResourceLocation id, CompoundTag structureNbt, String name, IIngredientManager ingredientManager) {
        this.id = id;
        this.structureNbt = structureNbt;
        this.name = name;
        this.structure = new MultiblockStructure(structureNbt);
        this.currentLayer = this.structure.getMaxY();
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (BlockPos pos : this.structure.getBlocks().keySet()) {
            Block block = this.structure.getBlocks().get(pos).m_60734_();
            if (blocks.contains(block)) continue;
            blocks.add(block);
            this.structureIngredients.add(new ItemStack((ItemLike)block));
        }
        for (ItemStack stackItem : this.structureIngredients) {
            for (Map.Entry<BlockPos, BlockState> block : this.structure.getBlocks().entrySet()) {
                if (!stackItem.m_150930_(block.getValue().m_60734_().m_5456_())) continue;
                stackItem.m_41764_(stackItem.m_41613_() + 1);
            }
            stackItem.m_41764_(stackItem.m_41613_() - 1);
        }
        this.ingredientManager = ingredientManager;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public CompoundTag getStructureNbt() {
        return this.structureNbt;
    }

    public String getName() {
        return this.name;
    }

    public MultiblockStructure getStructure() {
        return this.structure;
    }

    public void slice() {
        if (this.structure.getMaxY() < this.currentLayer) {
            this.currentLayer = this.structure.getMaxY();
        }
        --this.currentLayer;
        if (this.currentLayer < this.structure.getMinY()) {
            this.currentLayer = this.structure.getMaxY();
        }
    }

    public Ingredient getStructureIngredients() {
        Ingredient ingredient = Ingredient.m_43927_((ItemStack[])this.structureIngredients.toArray(new ItemStack[0]));
        return ingredient;
    }

    public Ingredient getIngredients() {
        Ingredient ingredient = Ingredient.m_43927_((ItemStack[])this.outputs.toArray(new ItemStack[0]));
        return ingredient;
    }

    public IIngredientManager getIngredientManager() {
        return this.ingredientManager;
    }

    public void setSpatialRecipe(SpatialCrafterRecipe spatialRecipe) {
        this.spatialRecipe = spatialRecipe;
        if (spatialRecipe != null && !spatialRecipe.getOutputs().isEmpty()) {
            this.outputs.clear();
            this.outputs.addAll(spatialRecipe.getOutputs());
        }
    }

    public SpatialCrafterRecipe getSpatialRecipe() {
        return this.spatialRecipe;
    }

    public boolean hasSpatialRecipe() {
        return this.spatialRecipe != null;
    }

    public List<ItemStack> getRecipeOutputs() {
        return this.spatialRecipe != null ? this.spatialRecipe.getOutputs() : new ArrayList();
    }

    public int getProcessingTime() {
        return this.spatialRecipe != null ? this.spatialRecipe.getProcessingTime() : 0;
    }

    public int getEnergyConsumption() {
        return this.spatialRecipe != null ? this.spatialRecipe.getEnergyConsumption() : 0;
    }

    public List<SpatialCrafterRecipe.EntityOutput> getRecipeEntities() {
        return this.spatialRecipe != null ? this.spatialRecipe.getEntityOutputs() : List.of();
    }
}

