/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.network;

import igentuman.spatialcrafter.block.SpatialCrafterBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SizeChangePacket {
    private final BlockPos pos;
    private final int newSize;

    public SizeChangePacket(BlockPos pos, int newSize) {
        this.pos = pos;
        this.newSize = newSize;
    }

    public static void encode(SizeChangePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.writeInt(packet.newSize);
    }

    public static SizeChangePacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        int newSize = buffer.readInt();
        return new SizeChangePacket(pos, newSize);
    }

    public static void handle(SizeChangePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            BlockEntity be;
            if (context.getSender() != null && (be = context.getSender().m_9236_().m_7702_(packet.pos)) instanceof SpatialCrafterBlockEntity) {
                SpatialCrafterBlockEntity spatialCrafter = (SpatialCrafterBlockEntity)be;
                spatialCrafter.setSize(packet.newSize);
            }
        });
        context.setPacketHandled(true);
    }
}

