/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.recipe;

import igentuman.spatialcrafter.recipe.SpatialCrafterRecipeSerializer;
import igentuman.spatialcrafter.recipe.SpatialCrafterRecipeType;
import igentuman.spatialcrafter.util.MultiblockStructure;
import igentuman.spatialcrafter.util.MultiblocksProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SpatialCrafterRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ResourceLocation multiblockId;
    private final List<ItemStack> outputs;
    private final List<EntityOutput> entityOutputs;
    private final int processingTime;
    private final int energyConsumption;
    private final CompoundTag outputNbt;
    private final boolean doNotDestroy;
    private final HashMap<Long, BlockState> requiredBlockStates = new HashMap();
    private final HashMap<Long, BlockState> requiredBlockStatesCW = new HashMap();
    private final HashMap<Long, BlockState> requiredBlockStatesCCW = new HashMap();
    private final HashMap<Long, BlockState> requiredBlockStatesOposite = new HashMap();

    public SpatialCrafterRecipe(ResourceLocation id, ResourceLocation multiblockId, List<ItemStack> outputs, List<EntityOutput> entityOutputs, int processingTime, int energyConsumption, CompoundTag outputNbt, boolean doNotDestroy) {
        this.id = id;
        this.multiblockId = multiblockId;
        this.outputs = outputs;
        this.entityOutputs = entityOutputs;
        this.processingTime = processingTime;
        this.energyConsumption = energyConsumption;
        this.outputNbt = outputNbt;
        this.doNotDestroy = doNotDestroy;
        this.initBlockStates();
    }

    private void initBlockStates() {
        MultiblockStructure structure = MultiblocksProvider.getStructures().stream().filter(s -> s.getId().equals((Object)this.multiblockId)).findFirst().orElse(null);
        if (structure == null) {
            return;
        }
        this.requiredBlockStates.clear();
        this.requiredBlockStatesCW.clear();
        this.requiredBlockStatesCCW.clear();
        this.requiredBlockStatesOposite.clear();
        Map<BlockPos, BlockState> originalBlocks = structure.getBlocks();
        BlockPos structureCenter = structure.getCenter();
        HashMap<BlockPos, BlockState> relativeBlocks = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, BlockState> entry : originalBlocks.entrySet()) {
            BlockPos absolutePos = entry.getKey();
            BlockPos relativePos = new BlockPos(absolutePos.m_123341_() - structureCenter.m_123341_(), absolutePos.m_123342_() - structureCenter.m_123342_(), absolutePos.m_123343_() - structureCenter.m_123343_());
            relativeBlocks.put(relativePos, entry.getValue());
            this.requiredBlockStates.put(relativePos.m_121878_(), entry.getValue());
        }
        this.generateRotatedBlockStates(relativeBlocks);
    }

    private void generateRotatedBlockStates(Map<BlockPos, BlockState> originalBlocks) {
        Map<BlockPos, BlockState> clockwiseBlocks = this.rotateBlocksClockwise(originalBlocks);
        for (Map.Entry<BlockPos, BlockState> entry : clockwiseBlocks.entrySet()) {
            long l = entry.getKey().m_121878_();
            this.requiredBlockStatesCW.put(l, entry.getValue());
        }
        Map<BlockPos, BlockState> counterClockwiseBlocks = this.rotateBlocksCounterClockwise(originalBlocks);
        for (Map.Entry<BlockPos, BlockState> entry : counterClockwiseBlocks.entrySet()) {
            long posKey = entry.getKey().m_121878_();
            this.requiredBlockStatesCCW.put(posKey, entry.getValue());
        }
        Map<BlockPos, BlockState> map = this.rotateBlocksOpposite(originalBlocks);
        for (Map.Entry<BlockPos, BlockState> entry : map.entrySet()) {
            long posKey = entry.getKey().m_121878_();
            this.requiredBlockStatesOposite.put(posKey, entry.getValue());
        }
    }

    private Map<BlockPos, BlockState> rotateBlocksClockwise(Map<BlockPos, BlockState> originalBlocks) {
        HashMap<BlockPos, BlockState> rotatedBlocks = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, BlockState> entry : originalBlocks.entrySet()) {
            BlockPos originalPos = entry.getKey();
            BlockState originalState = entry.getValue();
            BlockPos rotatedPos = new BlockPos(-originalPos.m_123343_(), originalPos.m_123342_(), originalPos.m_123341_());
            BlockState rotatedState = this.rotateBlockStateClockwise(originalState);
            rotatedBlocks.put(rotatedPos, rotatedState);
        }
        return rotatedBlocks;
    }

    private Map<BlockPos, BlockState> rotateBlocksCounterClockwise(Map<BlockPos, BlockState> originalBlocks) {
        HashMap<BlockPos, BlockState> rotatedBlocks = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, BlockState> entry : originalBlocks.entrySet()) {
            BlockPos originalPos = entry.getKey();
            BlockState originalState = entry.getValue();
            BlockPos rotatedPos = new BlockPos(originalPos.m_123343_(), originalPos.m_123342_(), -originalPos.m_123341_());
            BlockState rotatedState = this.rotateBlockStateCounterClockwise(originalState);
            rotatedBlocks.put(rotatedPos, rotatedState);
        }
        return rotatedBlocks;
    }

    private Map<BlockPos, BlockState> rotateBlocksOpposite(Map<BlockPos, BlockState> originalBlocks) {
        HashMap<BlockPos, BlockState> rotatedBlocks = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, BlockState> entry : originalBlocks.entrySet()) {
            BlockPos originalPos = entry.getKey();
            BlockState originalState = entry.getValue();
            BlockPos rotatedPos = new BlockPos(-originalPos.m_123341_(), originalPos.m_123342_(), -originalPos.m_123343_());
            BlockState rotatedState = this.rotateBlockStateOpposite(originalState);
            rotatedBlocks.put(rotatedPos, rotatedState);
        }
        return rotatedBlocks;
    }

    private BlockState rotateBlockStateClockwise(BlockState state) {
        Direction facing;
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            Direction facing2 = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            Direction rotatedFacing = facing2.m_122427_();
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotatedFacing);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61372_) && (facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_() != Direction.Axis.Y) {
            Direction rotatedFacing = facing.m_122427_();
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rotatedFacing);
        }
        return state;
    }

    private BlockState rotateBlockStateCounterClockwise(BlockState state) {
        Direction facing;
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            Direction facing2 = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            Direction rotatedFacing = facing2.m_122428_();
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotatedFacing);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61372_) && (facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_() != Direction.Axis.Y) {
            Direction rotatedFacing = facing.m_122428_();
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rotatedFacing);
        }
        return state;
    }

    private BlockState rotateBlockStateOpposite(BlockState state) {
        Direction facing;
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            Direction facing2 = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            Direction rotatedFacing = facing2.m_122424_();
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotatedFacing);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61372_) && (facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_() != Direction.Axis.Y) {
            Direction rotatedFacing = facing.m_122424_();
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rotatedFacing);
        }
        return state;
    }

    public boolean m_5818_(Container container, Level level) {
        return true;
    }

    public boolean matchesMultiblock(MultiblockStructure structure) {
        return structure.getId().equals((Object)this.multiblockId);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.outputs.isEmpty() ? ItemStack.f_41583_ : this.outputs.get(0).m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.outputs.isEmpty() ? ItemStack.f_41583_ : this.outputs.get(0);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SpatialCrafterRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return SpatialCrafterRecipeType.INSTANCE;
    }

    public ResourceLocation getMultiblockId() {
        return this.multiblockId;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public List<EntityOutput> getEntityOutputs() {
        return this.entityOutputs;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public int getEnergyConsumption() {
        return this.energyConsumption;
    }

    public CompoundTag getOutputNbt() {
        return this.outputNbt;
    }

    public boolean getDoNotDestroy() {
        return this.doNotDestroy;
    }

    public HashMap<Long, BlockState> getRequiredBlockStates() {
        return this.requiredBlockStates;
    }

    public HashMap<Long, BlockState> getRequiredBlockStatesCW() {
        return this.requiredBlockStatesCW;
    }

    public HashMap<Long, BlockState> getRequiredBlockStatesCCW() {
        return this.requiredBlockStatesCCW;
    }

    public HashMap<Long, BlockState> getRequiredBlockStatesOpposite() {
        return this.requiredBlockStatesOposite;
    }

    public boolean matchesBlocks(HashMap<Long, BlockState> values) {
        if (values == null || values.isEmpty()) {
            return false;
        }
        if (this.requiredBlockStates.isEmpty()) {
            this.initBlockStates();
        }
        if (values.size() != this.requiredBlockStates.size()) {
            return false;
        }
        return this.matchesOrientation(values, this.requiredBlockStates) || this.matchesOrientation(values, this.requiredBlockStatesCW) || this.matchesOrientation(values, this.requiredBlockStatesCCW) || this.matchesOrientation(values, this.requiredBlockStatesOposite);
    }

    private boolean matchesOrientation(HashMap<Long, BlockState> providedBlocks, HashMap<Long, BlockState> requiredBlocks) {
        if (requiredBlocks.isEmpty()) {
            return false;
        }
        for (Map.Entry<Long, BlockState> requiredEntry : requiredBlocks.entrySet()) {
            Long requiredPos = requiredEntry.getKey();
            BlockState requiredState = requiredEntry.getValue();
            if (providedBlocks.containsKey(requiredPos) && providedBlocks.get(requiredPos).equals(requiredState)) continue;
            return false;
        }
        return true;
    }

    public MultiblockStructure getStructure() {
        return MultiblocksProvider.getStructures().stream().filter(s -> s.getId().equals((Object)this.multiblockId)).findFirst().orElse(null);
    }

    public static class EntityOutput {
        private final EntityType<?> entityType;
        private final CompoundTag nbt;
        private final BlockPos relativePos;
        private final int count;

        public EntityOutput(EntityType<?> entityType, CompoundTag nbt, BlockPos relativePos, int count) {
            this.entityType = entityType;
            this.nbt = nbt;
            this.relativePos = relativePos;
            this.count = count;
        }

        public EntityType<?> getEntityType() {
            return this.entityType;
        }

        public CompoundTag getNbt() {
            return this.nbt;
        }

        public BlockPos getRelativePos() {
            return this.relativePos;
        }

        public int getCount() {
            return this.count;
        }
    }
}

