/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.recipe;

import igentuman.spatialcrafter.recipe.SpatialCrafterRecipe;
import igentuman.spatialcrafter.recipe.SpatialCrafterRecipeType;
import igentuman.spatialcrafter.util.MultiblockStructure;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class SpatialCrafterRecipeManager {
    private static boolean isRecipeValid(SpatialCrafterRecipe recipe) {
        for (ItemStack output : recipe.getOutputs()) {
            if (ForgeRegistries.ITEMS.getValue(ForgeRegistries.ITEMS.getKey((Object)output.m_41720_())) != null) continue;
            return false;
        }
        for (SpatialCrafterRecipe.EntityOutput entityOutput : recipe.getEntityOutputs()) {
            if (ForgeRegistries.ENTITY_TYPES.getValue(ForgeRegistries.ENTITY_TYPES.getKey(entityOutput.getEntityType())) != null) continue;
            return false;
        }
        return true;
    }

    public static Optional<SpatialCrafterRecipe> findRecipe(Level level, HashMap<Long, BlockState> blockStates) {
        RecipeManager recipeManager = level.m_7465_();
        return recipeManager.m_44013_((RecipeType)SpatialCrafterRecipeType.INSTANCE).stream().filter(SpatialCrafterRecipeManager::isRecipeValid).filter(recipe -> recipe.matchesBlocks(blockStates)).findFirst();
    }

    public static List<SpatialCrafterRecipe> getAllRecipes(Level level) {
        RecipeManager recipeManager = level.m_7465_();
        return recipeManager.m_44013_((RecipeType)SpatialCrafterRecipeType.INSTANCE).stream().filter(SpatialCrafterRecipeManager::isRecipeValid).collect(Collectors.toList());
    }

    public static List<SpatialCrafterRecipe> getRecipesForMultiblock(Level level, MultiblockStructure structure) {
        RecipeManager recipeManager = level.m_7465_();
        return recipeManager.m_44013_((RecipeType)SpatialCrafterRecipeType.INSTANCE).stream().filter(SpatialCrafterRecipeManager::isRecipeValid).filter(recipe -> recipe.matchesMultiblock(structure)).collect(Collectors.toList());
    }
}

