/*
 * Decompiled with CFR 0.152.
 */
package igentuman.spatialcrafter.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import igentuman.spatialcrafter.recipe.SpatialCrafterRecipe;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistries;

public class SpatialCrafterRecipeSerializer
implements RecipeSerializer<SpatialCrafterRecipe> {
    public static final SpatialCrafterRecipeSerializer INSTANCE = new SpatialCrafterRecipeSerializer();

    public SpatialCrafterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        ResourceLocation multiblockId = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"multiblock"));
        if (multiblockId == null) {
            throw new JsonParseException("Invalid multiblock ID in recipe " + recipeId);
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (json.has("outputs")) {
            JsonArray outputsArray = GsonHelper.m_13933_((JsonObject)json, (String)"outputs");
            for (Object element : outputsArray) {
                JsonObject outputObj = element.getAsJsonObject();
                ItemStack stack = ShapedRecipe.m_151274_((JsonObject)outputObj);
                if (outputObj.has("nbt")) {
                    try {
                        CompoundTag nbt = TagParser.m_129359_((String)outputObj.get("nbt").getAsString());
                        stack.m_41751_(nbt);
                    }
                    catch (Exception e) {
                        throw new JsonParseException("Invalid NBT data in recipe " + recipeId, (Throwable)e);
                    }
                }
                outputs.add(stack);
            }
        }
        ArrayList<SpatialCrafterRecipe.EntityOutput> entityOutputs = new ArrayList<SpatialCrafterRecipe.EntityOutput>();
        if (json.has("entity_outputs")) {
            JsonArray entityArray = GsonHelper.m_13933_((JsonObject)json, (String)"entity_outputs");
            for (JsonElement element : entityArray) {
                JsonObject entityObj = element.getAsJsonObject();
                ResourceLocation entityId = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)entityObj, (String)"entity"));
                if (entityId == null) {
                    throw new JsonParseException("Invalid entity ID in recipe " + recipeId);
                }
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
                if (entityType == null) {
                    throw new JsonParseException("Unknown entity type '" + entityId + "' in recipe " + recipeId);
                }
                CompoundTag nbt = new CompoundTag();
                if (entityObj.has("nbt")) {
                    try {
                        nbt = TagParser.m_129359_((String)entityObj.get("nbt").getAsString());
                    }
                    catch (Exception e) {
                        throw new JsonParseException("Invalid entity NBT data in recipe " + recipeId, (Throwable)e);
                    }
                }
                BlockPos relativePos = BlockPos.f_121853_;
                if (entityObj.has("position")) {
                    JsonArray posArray = GsonHelper.m_13933_((JsonObject)entityObj, (String)"position");
                    relativePos = new BlockPos(posArray.get(0).getAsInt(), posArray.get(1).getAsInt(), posArray.get(2).getAsInt());
                }
                int count = GsonHelper.m_13824_((JsonObject)entityObj, (String)"count", (int)1);
                entityOutputs.add(new SpatialCrafterRecipe.EntityOutput(entityType, nbt, relativePos, count));
            }
        }
        int processingTime = GsonHelper.m_13824_((JsonObject)json, (String)"processing_time", (int)200);
        int energyConsumption = GsonHelper.m_13824_((JsonObject)json, (String)"energy_consumption", (int)1000);
        boolean doNotDestroy = GsonHelper.m_13855_((JsonObject)json, (String)"do_not_destroy", (boolean)false);
        CompoundTag outputNbt = new CompoundTag();
        if (json.has("global_nbt")) {
            try {
                outputNbt = TagParser.m_129359_((String)json.get("global_nbt").getAsString());
            }
            catch (Exception e) {
                throw new JsonParseException("Invalid global NBT data in recipe " + recipeId, (Throwable)e);
            }
        }
        return new SpatialCrafterRecipe(recipeId, multiblockId, outputs, entityOutputs, processingTime, energyConsumption, outputNbt, doNotDestroy);
    }

    @Nullable
    public SpatialCrafterRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ResourceLocation multiblockId = buffer.m_130281_();
        int outputCount = buffer.m_130242_();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (int i = 0; i < outputCount; ++i) {
            outputs.add(buffer.m_130267_());
        }
        int entityOutputCount = buffer.m_130242_();
        ArrayList<SpatialCrafterRecipe.EntityOutput> entityOutputs = new ArrayList<SpatialCrafterRecipe.EntityOutput>();
        for (int i = 0; i < entityOutputCount; ++i) {
            ResourceLocation entityId = buffer.m_130281_();
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            CompoundTag nbt = buffer.m_130260_();
            BlockPos pos = buffer.m_130135_();
            int count = buffer.m_130242_();
            if (entityType == null) {
                throw new RuntimeException("Unknown entity type '" + entityId + "' received from network");
            }
            entityOutputs.add(new SpatialCrafterRecipe.EntityOutput(entityType, nbt, pos, count));
        }
        int processingTime = buffer.m_130242_();
        int energyConsumption = buffer.m_130242_();
        CompoundTag outputNbt = buffer.m_130260_();
        boolean doNotDestroy = buffer.readBoolean();
        return new SpatialCrafterRecipe(recipeId, multiblockId, outputs, entityOutputs, processingTime, energyConsumption, outputNbt, doNotDestroy);
    }

    public void toNetwork(FriendlyByteBuf buffer, SpatialCrafterRecipe recipe) {
        buffer.m_130085_(recipe.getMultiblockId());
        buffer.m_130130_(recipe.getOutputs().size());
        for (ItemStack output : recipe.getOutputs()) {
            buffer.m_130055_(output);
        }
        buffer.m_130130_(recipe.getEntityOutputs().size());
        for (SpatialCrafterRecipe.EntityOutput entityOutput : recipe.getEntityOutputs()) {
            buffer.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(entityOutput.getEntityType()));
            buffer.m_130079_(entityOutput.getNbt());
            buffer.m_130064_(entityOutput.getRelativePos());
            buffer.m_130130_(entityOutput.getCount());
        }
        buffer.m_130130_(recipe.getProcessingTime());
        buffer.m_130130_(recipe.getEnergyConsumption());
        buffer.m_130079_(recipe.getOutputNbt());
        buffer.writeBoolean(recipe.getDoNotDestroy());
    }
}

