/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.util;

import net.minecraft.class_3532;

public final class MathHelper {
    public static final float PI = (float)Math.PI;
    public static final float TAU = (float)Math.PI * 2;
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    private static final float RAD_TO_DEG = 57.29578f;

    private MathHelper() {
    }

    public static float toRadians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static float toDegrees(float degrees) {
        return degrees * 57.29578f;
    }

    public static float lerp(float a, float b, float t) {
        return t <= 0.0f ? a : (t >= 1.0f ? b : a + (b - a) * t);
    }

    public static float lerpDegrees(float a, float b, float t) {
        return a + t * MathHelper.getDifference(a, b, 360.0f);
    }

    public static double lerpDegrees(double a, double b, double t) {
        return a + t * MathHelper.getDifference(a, b, 360.0);
    }

    private static float getDifference(float a, float b, float rot) {
        return MathHelper.mod(b - a + rot / 2.0f, rot) - rot / 2.0f;
    }

    private static double getDifference(double a, double b, double rot) {
        return MathHelper.mod(b - a + rot / 2.0, rot) - rot / 2.0;
    }

    public static int mod(int a, int b) {
        return (a % b + b) % b;
    }

    public static float mod(float a, float b) {
        return (a % b + b) % b;
    }

    public static double mod(double a, double b) {
        return (a % b + b) % b;
    }

    public static float easeInOut(float t) {
        return -(class_3532.method_15362((float)((float)Math.PI * t)) - 1.0f) / 2.0f;
    }

    public static float easeOutCirc(float t) {
        return class_3532.method_15355((float)(1.0f - (t - 1.0f) * (t - 1.0f)));
    }

    public static float transform(float x, float domainMin, float domainMax, float rangeMin, float rangeMax) {
        if (x <= domainMin) {
            return rangeMin;
        }
        if (x >= domainMax) {
            return rangeMax;
        }
        return (rangeMax - rangeMin) * (x - domainMin) / (domainMax - domainMin) + rangeMin;
    }
}

