/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.handler;

import com.google.common.collect.ImmutableSet;
import fuzs.fantasticwings.client.FantasticWingsClient;
import fuzs.fantasticwings.flight.apparatus.FlightApparatusImpl;
import fuzs.puzzleslib.api.client.data.v2.AbstractModelProvider;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class PotionItemModelHandler {
    public static final Item[] POTION_ITEMS = new Item[]{Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION};
    private static final Set<ModelResourceLocation> POTION_MODEL_LOCATIONS = (Set)Stream.of(POTION_ITEMS).map(item -> ModelResourceLocation.inventory((ResourceLocation)item.builtInRegistryHolder().key().location())).collect(ImmutableSet.toImmutableSet());

    public static EventResultHolder<UnbakedModel> onModifyUnbakedModel(ModelResourceLocation modelLocation, Supplier<UnbakedModel> unbakedModel, Function<ModelResourceLocation, UnbakedModel> modelGetter, BiConsumer<ResourceLocation, UnbakedModel> modelAdder) {
        UnbakedModel unbakedModel2;
        if (POTION_MODEL_LOCATIONS.contains(modelLocation) && (unbakedModel2 = unbakedModel.get()) instanceof BlockModel) {
            BlockModel blockModel = (BlockModel)unbakedModel2;
            FlightApparatusImpl.forEach(flightApparatus -> PotionItemModelHandler.registerItemOverride(blockModel, flightApparatus.textureLocation(), flightApparatus.modelLocation()));
            PotionItemModelHandler.registerItemOverride(blockModel, FantasticWingsClient.BAT_BLOOD_BOTTLE_TEXTURE_LOCATION, AbstractModelProvider.decorateItemModelLocation((ResourceLocation)FantasticWingsClient.BAT_BLOOD_BOTTLE_TEXTURE_LOCATION));
            return EventResultHolder.interrupt((Object)blockModel);
        }
        return EventResultHolder.pass();
    }

    private static void registerItemOverride(BlockModel blockModel, ResourceLocation itemModelProperty, ResourceLocation overrideModelLocation) {
        ItemOverride.Predicate itemPredicate = new ItemOverride.Predicate(itemModelProperty, 1.0f);
        ItemOverride itemOverride = new ItemOverride(overrideModelLocation, Collections.singletonList(itemPredicate));
        blockModel.getOverrides().add(itemOverride);
    }
}

