/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.handler;

import fuzs.fantasticwings.client.audio.WingsSound;
import fuzs.fantasticwings.client.flight.FlightViewCapability;
import fuzs.fantasticwings.client.init.ClientModRegistry;
import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.util.MathHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_759;
import net.minecraft.class_7833;

public class ClientEventHandler {
    public static void onAnimatePlayerModel(class_1657 player, class_591<?> model, float ticksExisted, float pitch) {
        float delta;
        FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player);
        float flyingAmount = flightCapability.getFlyingAmount(delta = ticksExisted - (float)player.field_6012);
        if (flyingAmount != 0.0f) {
            model.field_3398.field_3654 = MathHelper.toRadians(MathHelper.lerp(pitch, pitch / 4.0f - 90.0f, flyingAmount));
            model.field_27433.field_3654 = MathHelper.lerp(model.field_27433.field_3654, -3.2f, flyingAmount);
            model.field_3401.field_3654 = MathHelper.lerp(model.field_3401.field_3654, -3.2f, flyingAmount);
            model.field_3397.field_3654 = MathHelper.lerp(model.field_3397.field_3654, 0.0f, flyingAmount);
            model.field_3392.field_3654 = MathHelper.lerp(model.field_3392.field_3654, 0.0f, flyingAmount);
            model.field_3394.method_17138(model.field_3398);
        }
    }

    public static void onApplyRotations(class_1657 player, class_4587 poseStack, float delta) {
        FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player);
        float amt = flightCapability.getFlyingAmount(delta);
        if (amt > 0.0f) {
            float roll = MathHelper.lerpDegrees(player.field_6220 - player.field_5982, player.field_6283 - player.method_36454(), delta);
            float pitch = -MathHelper.lerpDegrees(player.field_6004, player.method_36455(), delta) - 90.0f;
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(MathHelper.lerpDegrees(0.0f, roll, amt)));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(MathHelper.lerpDegrees(0.0f, pitch, amt)));
            poseStack.method_22904(0.0, -1.2 * (double)MathHelper.easeInOut(amt), 0.0);
        }
    }

    public static void onComputeCameraAngles(class_757 renderer, class_4184 camera, float partialTick, MutableFloat pitch, MutableFloat yaw, MutableFloat roll) {
        ModRegistry.FLIGHT_CAPABILITY.getIfProvided((Object)camera.method_19331()).ifPresent(flightViewCapability -> {
            float flyingAmount = flightViewCapability.getFlyingAmount(partialTick);
            if (flyingAmount > 0.0f) {
                class_1657 player = (class_1657)camera.method_19331();
                float newRoll = MathHelper.lerpDegrees(player.field_6220 - player.field_5982, player.field_6283 - player.method_36454(), partialTick);
                roll.accept(MathHelper.lerpDegrees(0.0f, -newRoll * 0.25f, flyingAmount));
            }
        });
    }

    public static EventResult onEntityLoad(class_1297 entity, class_638 level) {
        if (entity instanceof class_746) {
            class_746 localPlayer = (class_746)entity;
            FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)localPlayer);
            class_310.method_1551().method_1483().method_4873((class_1113)new WingsSound((class_1657)localPlayer, flightCapability));
        }
        return EventResult.PASS;
    }

    public static void onEndPlayerTick(class_1657 player) {
        ClientModRegistry.FLIGHT_VIEW_CAPABILITY.getIfProvided((Object)player).ifPresent(FlightViewCapability::tick);
    }

    public static EventResult onRenderOffHand(class_759 itemInHandRenderer, class_742 player, class_1306 humanoidArm, class_1799 itemStack, class_4587 poseStack, class_4597 multiBufferSource, int combinedLight, float partialTick, float interpolatedPitch, float swingProgress, float equipProgress) {
        if (itemStack.method_7960() && !player.method_31550() && !player.method_5767() && !itemInHandRenderer.field_4047.method_31574(class_1802.field_8204) && ((FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player)).isFlying()) {
            itemInHandRenderer.method_3219(poseStack, multiBufferSource, combinedLight, equipProgress, swingProgress, player.method_6068().method_5928());
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static void onTurn(class_1297 entity, float deltaYaw) {
        float theta;
        class_1657 player;
        if (entity instanceof class_1657 && ((FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)(player = (class_1657)entity))).isFlying() && ((theta = class_3532.method_15393((float)(player.method_36454() - player.field_6283))) < -50.0f || theta > 50.0f)) {
            player.field_6283 += deltaYaw;
            player.field_6220 += deltaYaw;
        }
    }
}

