/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.model;

import fuzs.fantasticwings.client.model.pipeline.ForwardingVertexConsumer;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public final class Model3DTexture
extends class_630.class_628 {
    private Model3DTexture(float posX, float posY, float posZ, int width, int height, float u1, float v1, float u2, float v2, int textureWidth, int textureHeight) {
        super(0, 0, posX, posY, posZ, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, (float)textureWidth, (float)textureHeight, EnumSet.allOf(class_2350.class));
        float f9;
        float f8;
        float f82;
        float f7;
        int k;
        int faceCount = 2 + 2 * width + 2 * height;
        class_630.class_593[] polygons = new class_630.class_593[faceCount];
        float x0 = this.field_3645;
        float x1 = this.field_3645 + (float)width;
        float y0 = this.field_3644;
        float y1 = this.field_3644 + (float)height;
        float z0 = this.field_3643;
        float z1 = this.field_3643 + 1.0f;
        FaceAdder faces = Model3DTexture.getFaceAdder(polygons);
        faces.add(x0, y0, z0, x1, y1, z0, u1, v1, u2, v2, class_2350.field_11043);
        faces.add(x0, y1, z1, x1, y0, z1, u1, v2, u2, v1, class_2350.field_11035);
        float f5 = 0.5f * (u1 - u2) / (float)width;
        float f6 = 0.5f * (v1 - v2) / (float)height;
        for (k = 0; k < width; ++k) {
            f7 = x0 + (float)k;
            f82 = u1 + (u2 - u1) * ((float)k / (float)width) - f5;
            faces.add(f7, y0, z0, f7, y1, z1, f82, v1, f82, v2, class_2350.field_11039);
        }
        for (k = 0; k < width; ++k) {
            f8 = u1 + (u2 - u1) * ((float)k / (float)width) - f5;
            f9 = x0 + (float)(k + 1);
            faces.add(f9, y1, z0, f9, y0, z1, f8, v2, f8, v1, class_2350.field_11034);
        }
        for (k = 0; k < height; ++k) {
            f8 = v1 + (v2 - v1) * ((float)k / (float)height) - f6;
            f9 = y0 + (float)(k + 1);
            faces.add(x0, f9, z0, x1, f9, z1, u1, f8, u2, f8, class_2350.field_11036);
        }
        for (k = 0; k < height; ++k) {
            f7 = y0 + (float)k;
            f82 = v1 + (v2 - v1) * ((float)k / (float)height) - f6;
            faces.add(x1, f7, z0, x0, f7, z1, u2, f82, u1, f82, class_2350.field_11033);
        }
        this.field_3649 = polygons;
    }

    public void method_32089(class_4587.class_4665 pose, class_4588 vertexConsumer, int packedLight, int packedOverlay, int color) {
        super.method_32089(pose, (class_4588)new ForwardingVertexConsumer(vertexConsumer), packedLight, packedOverlay, color);
    }

    private static FaceAdder getFaceAdder(class_630.class_593[] polygons) {
        AtomicInteger polygonIndex = new AtomicInteger();
        return (x0, y0, z0, x1, y1, z1, u1, v1, u2, v2, normal) -> {
            class_630.class_618[] vertices = new class_630.class_618[4];
            boolean vertical = normal.method_10166().method_10178();
            vertices[0] = new class_630.class_618(x1, y0, z0, 0.0f, 0.0f);
            vertices[1] = new class_630.class_618(x0, y0, vertical ? z0 : z1, 0.0f, 0.0f);
            vertices[2] = new class_630.class_618(x0, y1, z1, 0.0f, 0.0f);
            vertices[3] = new class_630.class_618(x1, y1, vertical ? z1 : z0, 0.0f, 0.0f);
            polygons[polygonIndex.getAndIncrement()] = new class_630.class_593(vertices, u1, v1, u2, v2, 64.0f, 64.0f, false, normal);
        };
    }

    public static Model3DTexture create(float posX, float posY, float posZ, int width, int height, int u, int v, int textureWidth, int textureHeight) {
        return new Model3DTexture(posX, posY, posZ, width, height, u, v, u + width, v + height, textureWidth, textureHeight);
    }

    @FunctionalInterface
    static interface FaceAdder {
        public void add(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, class_2350 var11);
    }
}

