/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.flight;

import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.network.ServerboundControlFlyingMessage;
import fuzs.fantasticwings.util.CubicBezier;
import fuzs.fantasticwings.util.MathHelper;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.api.network.v3.ServerboundMessage;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public final class FlightCapability
extends CapabilityComponent<class_1657> {
    private static final String KEY_IS_FLYING = FantasticWings.id("is_flying").toString();
    private static final String KEY_TIME_FLYING = FantasticWings.id("time_flying").toString();
    private static final String KEY_WING_TYPE = FantasticWings.id("wing_type").toString();
    private static final CubicBezier FLY_AMOUNT_CURVE = new CubicBezier(0.37f, 0.13f, 0.3f, 1.12f);
    private static final int INITIAL_TIME_FLYING = 0;
    private static final int MAX_TIME_FLYING = 20;
    private static final float MIN_SPEED = 0.03f;
    private static final float MAX_SPEED = 0.0715f;
    private static final float Y_BOOST = 0.05f;
    private static final float MANUAL_Y_BOOST = 0.06f;
    private static final float FALL_REDUCTION = 0.9f;
    private static final float PITCH_OFFSET = 30.0f;
    private int prevTimeFlying = 0;
    private int timeFlying = 0;
    private boolean isFlying;
    private FlightApparatus.FlightApparatusHolder holder = FlightApparatus.FlightApparatusHolder.empty();

    public void setIsFlying(boolean isFlying) {
        this.setIsFlying(isFlying, null);
    }

    public void setIsFlying(boolean isFlying, @Nullable PlayerSet playerSet) {
        if (this.isFlying != isFlying) {
            this.isFlying = isFlying;
            if (this.isFlying) {
                ((class_1657)this.getHolder()).method_18375();
            }
            this.setChanged(playerSet);
        }
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public void toggleIsFlying(PlayerSet playerSet) {
        this.setIsFlying(!this.isFlying, playerSet);
    }

    public void setTimeFlying(int timeFlying) {
        if (this.timeFlying != timeFlying) {
            this.timeFlying = timeFlying;
            this.setChanged(PlayerSet.ofNone());
        }
    }

    public void setWings(FlightApparatus.FlightApparatusHolder flightApparatus) {
        if (!this.holder.is(flightApparatus)) {
            this.holder = flightApparatus;
            this.setChanged();
        }
    }

    public FlightApparatus.FlightApparatusHolder getWings() {
        return this.holder;
    }

    public float getFlyingAmount(float delta) {
        return FLY_AMOUNT_CURVE.eval(MathHelper.lerp(this.prevTimeFlying, this.timeFlying, delta) / 20.0f);
    }

    public boolean canUseWings() {
        return !((class_1657)this.getHolder()).method_31549().field_7479 && !((class_1657)this.getHolder()).method_6118(class_1304.field_6174).method_31573(ModRegistry.WING_OBSTRUCTIONS);
    }

    public boolean canFly() {
        return this.holder.flightApparatus().isUsableForFlying((class_1657)this.getHolder()) && this.canUseWings();
    }

    public boolean canSlowlyDescend() {
        return this.holder.flightApparatus().isUsableForSlowlyDescending((class_1657)this.getHolder()) && this.canUseWings() && (this.isFlying() || !((class_1657)this.getHolder()).method_21752() && !((class_1657)this.getHolder()).method_31549().field_7478);
    }

    private void onWornUpdate() {
        class_1657 player = (class_1657)this.getHolder();
        if (!player.method_37908().field_9236 && this.isFlying() && !this.canFly()) {
            this.setIsFlying(false);
        }
        if (player.method_6034()) {
            if (this.isFlying()) {
                float speed = class_3532.method_37166((float)0.03f, (float)0.0715f, (float)player.field_6250);
                float elevationBoost = MathHelper.transform(Math.abs(player.method_36455()), 45.0f, 90.0f, 1.0f, 0.0f);
                float pitch = -MathHelper.toRadians(player.method_36455() - 30.0f * elevationBoost);
                float yaw = -MathHelper.toRadians(player.method_36454()) - (float)Math.PI;
                float vxz = -class_3532.method_15362((float)pitch);
                float vy = class_3532.method_15374((float)pitch);
                float vz = class_3532.method_15362((float)yaw);
                float vx = class_3532.method_15374((float)yaw);
                player.method_18799(player.method_18798().method_1031((double)(vx * vxz * speed), (double)(vy * speed) + (double)0.05f * (player.method_36455() > 0.0f ? (double)elevationBoost : 1.0), (double)(vz * vxz * speed)));
                if (player.field_6282) {
                    player.method_18799(player.method_18798().method_1031(0.0, (double)0.03f, 0.0));
                } else if (player.method_21752()) {
                    player.method_18799(player.method_18798().method_1031(0.0, (double)-0.06f, 0.0));
                }
            }
            if (this.canSlowlyDescend()) {
                class_243 deltaMovement = player.method_18798();
                if (deltaMovement.method_10214() < 0.0) {
                    player.method_18799(deltaMovement.method_18805(1.0, (double)0.9f, 1.0));
                }
                player.field_6017 = 0.0f;
            }
        }
    }

    public void tick() {
        class_1657 player = (class_1657)this.getHolder();
        if (!this.holder.isEmpty() || !player.method_6034()) {
            this.onWornUpdate();
        } else if (!player.method_37908().field_9236 && this.isFlying()) {
            this.setIsFlying(false);
        }
        this.prevTimeFlying = this.timeFlying;
        if (this.isFlying()) {
            if (this.timeFlying < 20) {
                this.setTimeFlying(this.timeFlying + 1);
            } else if (player.method_7340() && player.method_24828()) {
                this.setIsFlying(false, PlayerSet.ofNone());
                FantasticWings.NETWORK.sendMessage((ServerboundMessage)new ServerboundControlFlyingMessage(false));
            }
        } else if (this.timeFlying > 0) {
            this.setTimeFlying(this.timeFlying - 1);
        }
    }

    public void onFlown(class_243 direction) {
        class_1657 player = (class_1657)this.getHolder();
        if (this.isFlying()) {
            this.holder.flightApparatus().onFlying(player, direction);
        } else if (this.canSlowlyDescend() && player.method_18798().method_10214() < -0.5) {
            this.holder.flightApparatus().onSlowlyDescending(player, direction);
        }
    }

    public void write(class_2487 compoundTag, class_7225.class_7874 registries) {
        compoundTag.method_10556(KEY_IS_FLYING, this.isFlying);
        compoundTag.method_10569(KEY_TIME_FLYING, this.timeFlying);
        compoundTag.method_10566(KEY_WING_TYPE, (class_2520)this.holder.writeToNbtTag());
    }

    public void read(class_2487 compoundTag, class_7225.class_7874 registries) {
        this.isFlying = compoundTag.method_10577(KEY_IS_FLYING);
        this.timeFlying = compoundTag.method_10550(KEY_TIME_FLYING);
        this.holder = FlightApparatus.FlightApparatusHolder.readFromNbtTag(compoundTag.method_10562(KEY_WING_TYPE));
    }
}

