/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client;

import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.client.flight.FlightView;
import fuzs.fantasticwings.client.flight.apparatus.WingFormRegistry;
import fuzs.fantasticwings.client.handler.ClientEventHandler;
import fuzs.fantasticwings.client.init.ClientModRegistry;
import fuzs.fantasticwings.client.model.AvianWingsModel;
import fuzs.fantasticwings.client.model.InsectoidWingsModel;
import fuzs.fantasticwings.client.renderer.entity.layers.ModWingsLayer;
import fuzs.fantasticwings.client.renderer.item.properties.select.FlightApparatusProperty;
import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.network.ServerboundControlFlyingMessage;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelsContext;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LivingEntityRenderLayersContext;
import fuzs.puzzleslib.api.client.event.v1.AddResourcePackReloadListenersCallback;
import fuzs.puzzleslib.api.client.event.v1.entity.ClientEntityLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.ComputeCameraAnglesCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.ExtractRenderStateCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderHandEvents;
import fuzs.puzzleslib.api.client.key.v1.KeyActivationHandler;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.api.network.v3.ServerboundMessage;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;

public class FantasticWingsClient
implements ClientModConstructor {
    public void onConstructMod() {
        ClientModRegistry.bootstrap();
        FantasticWingsClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ComputeCameraAnglesCallback.EVENT.register(ClientEventHandler::onComputeCameraAngles);
        ClientEntityLevelEvents.LOAD.register(ClientEventHandler::onEntityLoad);
        PlayerTickEvents.END.register(FlightView::onEndPlayerTick);
        ExtractRenderStateCallback.EVENT.register(ClientEventHandler::onExtractRenderState);
        RenderHandEvents.OFF_HAND.register(ClientEventHandler::onRenderOffHand);
        AddResourcePackReloadListenersCallback.EVENT.register(consumer -> consumer.accept(FantasticWings.id("wing_models"), WingFormRegistry.INSTANCE));
    }

    public void onRegisterKeyMappings(KeyMappingsContext context) {
        context.registerKeyMapping(ClientModRegistry.FLY_KEY_MAPPING, KeyActivationHandler.forGame(minecraft -> {
            LocalPlayer player = minecraft.player;
            FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player);
            if (flightCapability.canFly((Player)player)) {
                flightCapability.toggleIsFlying((Player)player, PlayerSet.ofNone());
                FantasticWings.NETWORK.sendMessage((ServerboundMessage)new ServerboundControlFlyingMessage(flightCapability.isFlying()));
            }
        }));
    }

    public void onRegisterItemModels(ItemModelsContext context) {
        context.registerSelectItemModelProperty(FantasticWings.id("wings"), FlightApparatusProperty.TYPE);
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(WingFormRegistry.INSECTOID_WINGS_MODEL_LAYER, InsectoidWingsModel::createWingsLayer);
        context.registerLayerDefinition(WingFormRegistry.AVIAN_WINGS_MODEL_LAYER, AvianWingsModel::createWingsLayer);
    }

    public void onRegisterLivingEntityRenderLayers(LivingEntityRenderLayersContext context) {
        context.registerRenderLayer(EntityType.PLAYER, ModWingsLayer::new);
    }
}

