/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.flight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.fantasticwings.client.animator.Animator;
import fuzs.fantasticwings.client.animator.state.State;
import fuzs.fantasticwings.client.animator.state.StateIdle;
import fuzs.fantasticwings.client.flight.apparatus.WingForm;
import fuzs.fantasticwings.client.init.ClientModRegistry;
import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.init.ModRegistry;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record FlightView(WingState animator) {
    public static final FlightView VOID = new FlightView(PresentWingState.VOID);

    public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
        this.animator.ifFormPresent(consumer);
    }

    public static void onEndPlayerTick(Player player) {
        ClientModRegistry.FLIGHT_VIEW_ATTACHMENT_TYPE.update((Object)player, flightView -> flightView.tick(player));
    }

    private FlightView tick(Player player) {
        WingState animator = this.getFlight(player).getWings().flatMap(WingForm::get).map(this.animator::next).orElseGet(this.animator::nextAbsent);
        animator.update(this.getFlight(player), player);
        return new FlightView(animator);
    }

    public FlightCapability getFlight(Player player) {
        return (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player);
    }

    static interface WingState {
        public WingState nextAbsent();

        public WingState next(WingForm<?> var1);

        public void update(FlightCapability var1, Player var2);

        public void ifFormPresent(Consumer<WingForm.FormRenderer> var1);
    }

    private record PresentWingState(WingForm<?> wing, Strategy behavior) implements WingState
    {
        static final WingState VOID = new WingState(){

            @Override
            public WingState nextAbsent() {
                return this;
            }

            @Override
            public WingState next(WingForm<?> form) {
                return PresentWingState.newState(form);
            }

            @Override
            public void update(FlightCapability flight, Player player) {
            }

            @Override
            public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
            }
        };

        @Override
        public WingState nextAbsent() {
            return VOID;
        }

        @Override
        public WingState next(WingForm<?> form) {
            if (this.wing.equals(form)) {
                return this;
            }
            return PresentWingState.newState(form);
        }

        @Override
        public void update(FlightCapability flight, Player player) {
            this.behavior.update(flight, player);
        }

        @Override
        public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
            this.behavior.ifFormPresent(consumer);
        }

        public static <T extends Animator> WingState newState(WingForm<T> shape) {
            return new PresentWingState(shape, new WingStrategy<T>(shape));
        }

        private static class WingStrategy<T extends Animator>
        implements Strategy {
            private final WingForm<T> shape;
            private final T animator;
            private State state;

            public WingStrategy(WingForm<T> shape) {
                this.shape = shape;
                this.animator = shape.createAnimator();
                this.state = new StateIdle();
            }

            @Override
            public void update(FlightCapability flight, Player player) {
                this.animator.update();
                State state = this.state.update(flight, player.getX() - player.xo, player.getY() - player.yo, player.getZ() - player.zo, player);
                if (!this.state.equals(state)) {
                    state.beginAnimation((Animator)this.animator);
                }
                this.state = state;
            }

            @Override
            public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
                consumer.accept(new WingForm.FormRenderer(){

                    @Override
                    public ResourceLocation getTextureLocation() {
                        return shape.getTextureLocation();
                    }

                    @Override
                    public void render(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color, float partialTick) {
                        shape.getModel().setupAnim(animator, partialTick);
                        shape.getModel().renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
                    }
                });
            }
        }
    }

    private static interface Strategy {
        public void update(FlightCapability var1, Player var2);

        public void ifFormPresent(Consumer<WingForm.FormRenderer> var1);
    }
}

