/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.flight.apparatus;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.fantasticwings.client.animator.Animator;
import fuzs.fantasticwings.client.flight.apparatus.WingFormRegistry;
import fuzs.fantasticwings.client.model.WingsModel;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class WingForm<A extends Animator> {
    private final ResourceKey<FlightApparatus> resourceKey;
    private final Supplier<A> animator;
    private final Supplier<WingsModel<A>> model;
    private final ResourceLocation textureLocation;

    public WingForm(ResourceKey<FlightApparatus> resourceKey, Supplier<A> animator, Supplier<WingsModel<A>> model) {
        this.resourceKey = resourceKey;
        this.animator = animator;
        this.model = model;
        this.textureLocation = FlightApparatus.transformTextureLocation(FlightApparatus.getTextureLocation(resourceKey));
    }

    public A createAnimator() {
        return (A)((Animator)this.animator.get());
    }

    public WingsModel<A> getModel() {
        return this.model.get();
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof WingForm)) return false;
        WingForm wingForm = (WingForm)obj;
        if (wingForm.resourceKey != this.resourceKey) return false;
        return true;
    }

    public static Optional<WingForm<?>> get(Holder<FlightApparatus> holder) {
        return Optional.of(WingFormRegistry.INSTANCE.createWings(holder));
    }

    public static interface FormRenderer {
        public ResourceLocation getTextureLocation();

        public void render(PoseStack var1, VertexConsumer var2, int var3, int var4, int var5, float var6);
    }
}

