/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.flight.apparatus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.flight.apparatus.WingSettings;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public record FlightApparatus(ResourceLocation textureLocation, Model model, WingSettings wingSettings) {
    public static final ResourceKey<Registry<FlightApparatus>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)FantasticWings.id("wings"));
    public static final Codec<FlightApparatus> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("asset_id").forGetter(FlightApparatus::textureLocation), (App)Model.CODEC.fieldOf("model").forGetter(FlightApparatus::model), (App)WingSettings.CODEC.fieldOf("wing_settings").forGetter(FlightApparatus::wingSettings)).apply((Applicative)instance, FlightApparatus::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlightApparatus> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, FlightApparatus::textureLocation, Model.STREAM_CODEC, FlightApparatus::model, WingSettings.STREAM_CODEC, FlightApparatus::wingSettings, FlightApparatus::new);
    public static final Codec<Holder<FlightApparatus>> CODEC = RegistryFileCodec.create(REGISTRY_KEY, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<FlightApparatus>> STREAM_CODEC = ByteBufCodecs.holder(REGISTRY_KEY, DIRECT_STREAM_CODEC);

    public static ResourceLocation transformTextureLocation(ResourceLocation resourceLocation) {
        return resourceLocation.withPath(string -> "textures/" + string + ".png");
    }

    public static ResourceLocation getTextureLocation(ResourceKey<FlightApparatus> resourceKey) {
        return resourceKey.location().withPath(string -> "entity/equipment/wings/" + string);
    }

    public void onFlying(Player player, Vec3 direction) {
        int distance = Math.round((float)direction.length() * 100.0f);
        if (distance > 0) {
            player.causeFoodExhaustion((float)distance * this.wingSettings().exhaustionFromFlying());
        }
    }

    public void onSlowlyDescending(Player player, Vec3 direction) {
        player.causeFoodExhaustion(this.wingSettings().exhaustionFromSlowlyDescending());
    }

    public boolean isUsableForFlying(Player player) {
        return player.getAbilities().invulnerable || player.getFoodData().getFoodLevel() >= this.wingSettings().requiredFoodLevelForFlying();
    }

    public boolean isUsableForSlowlyDescending(Player player) {
        return player.getAbilities().invulnerable || player.getFoodData().getFoodLevel() >= this.wingSettings().requiredFoodLevelForSlowlyDescending();
    }

    public static enum Model implements StringRepresentable
    {
        AVIAN,
        INSECTOID;

        public static final StringRepresentable.StringRepresentableCodec<Model> CODEC;
        public static final IntFunction<Model> BY_ID;
        public static final StreamCodec<ByteBuf, Model> STREAM_CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Model::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Model.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

