/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.mixin;

import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.handler.ServerEventHandler;
import fuzs.fantasticwings.init.ModRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"isVisuallySwimming"}, at={@At(value="HEAD")}, cancellable=true)
    public void isVisuallySwimming(CallbackInfoReturnable<Boolean> callback) {
        if (!super.isVisuallySwimming() && ModRegistry.FLIGHT_CAPABILITY.getIfProvided((Object)this).filter(FlightCapability::isFlying).isPresent()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tickHeadTurn"}, at={@At(value="HEAD")}, cancellable=true)
    protected void tickHeadTurn(float yRot, float animStep, CallbackInfoReturnable<Float> callback) {
        if (ServerEventHandler.onUpdateBodyRotation((LivingEntity)LivingEntity.class.cast((Object)this), yRot)) {
            callback.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }
}

