/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.world.item.consume_effects;

import com.mojang.serialization.MapCodec;
import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.init.ModRegistry;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.Level;

public record TakeWingsConsumeEffect(Optional<Holder<FlightApparatus>> holder) implements ConsumeEffect
{
    public static final MapCodec<TakeWingsConsumeEffect> CODEC = FlightApparatus.CODEC.optionalFieldOf("wings").xmap(TakeWingsConsumeEffect::new, TakeWingsConsumeEffect::holder);
    public static final StreamCodec<RegistryFriendlyByteBuf, TakeWingsConsumeEffect> STREAM_CODEC = FlightApparatus.STREAM_CODEC.apply(ByteBufCodecs::optional).map(TakeWingsConsumeEffect::new, TakeWingsConsumeEffect::holder);

    public TakeWingsConsumeEffect() {
        this(Optional.empty());
    }

    public ConsumeEffect.Type<? extends ConsumeEffect> getType() {
        return (ConsumeEffect.Type)ModRegistry.TAKE_WINGS_CONSUME_EFFECT_TYPE.value();
    }

    public boolean apply(Level level, ItemStack stack, LivingEntity entity) {
        ServerPlayer serverPlayer;
        return entity instanceof ServerPlayer && TakeWingsConsumeEffect.takeWings(serverPlayer = (ServerPlayer)entity, this.holder);
    }

    public static boolean takeWings(ServerPlayer serverPlayer, Optional<Holder<FlightApparatus>> flightApparatus) {
        FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)serverPlayer);
        if (flightApparatus.isEmpty() || flightCapability.is(flightApparatus.get())) {
            if (flightCapability.setWings(null)) {
                serverPlayer.serverLevel().playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), (SoundEvent)ModRegistry.ITEM_ARMOR_EQUIP_WINGS.value(), SoundSource.PLAYERS, 1.0f, 0.8f);
                return true;
            }
            return false;
        }
        return false;
    }
}

