/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.api.biome.sub;

import com.mojang.serialization.Codec;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_5742;
import net.minecraft.class_6544;

public enum BiomeParameterTargets implements class_3542
{
    TEMPERATURE("temperature"),
    HUMIDITY("humidity"),
    CONTINENTALNESS("continentalness"),
    EROSION("erosion"),
    DEPTH("depth"),
    WEIRDNESS("weirdness"),
    PEAKS_VALLEYS("peaks_valleys"),
    DEPTH_OCEAN("depth_ocean");

    public static final Codec<BiomeParameterTargets> CODEC;
    private final String name;

    private BiomeParameterTargets(String name) {
        this.name = name;
    }

    public long getNoiseValue(class_6544.class_6553 noisePoint) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> noisePoint.comp_112();
            case 1 -> noisePoint.comp_113();
            case 2 -> noisePoint.comp_114();
            case 3 -> noisePoint.comp_115();
            case 4 -> noisePoint.comp_116();
            case 5 -> noisePoint.comp_117();
            case 6 -> BiomeParameterTargets.getPeaksValleysNoiseLong(noisePoint.comp_117());
            case 7 -> BiomeParameterTargets.getDepthWithOceanSurfaceLong(noisePoint.comp_116());
        };
    }

    public String method_15434() {
        return this.name;
    }

    public static long getPeaksValleysNoiseLong(long weirdness) {
        return 10000L - Math.abs(Math.abs(weirdness * 3L) - 20000L);
    }

    public static long getDepthWithOceanSurfaceLong(long depth) {
        class_3218 world = DimensionBiomePlacement.getEvaluatingWorld();
        int seaLevel = world.method_8615();
        double bottom = world.method_31607();
        double top = world.method_31600();
        double bottomNew = 15000.0;
        double topNew = -15000.0;
        return Math.max(depth, (long)class_3532.method_32854((double)class_5742.method_33101((int)DimensionBiomePlacement.getEvaluatingBiomePos().method_10264()), (double)bottom, (double)top, (double)bottomNew, (double)topNew) - (long)class_3532.method_32854((double)seaLevel, (double)bottom, (double)top, (double)bottomNew, (double)topNew));
    }

    public static long parameterCenter(class_6544.class_6546 range) {
        return (range.comp_103() + range.comp_104()) / 2L;
    }

    public static class_6544.class_6553 parametersCenterPoint(class_6544.class_6546[] parameters) {
        return new class_6544.class_6553(BiomeParameterTargets.parameterCenter(parameters[0]), BiomeParameterTargets.parameterCenter(parameters[1]), BiomeParameterTargets.parameterCenter(parameters[2]), BiomeParameterTargets.parameterCenter(parameters[3]), BiomeParameterTargets.parameterCenter(parameters[4]), BiomeParameterTargets.parameterCenter(parameters[5]));
    }

    public static long getSquaredDistance(class_6544.class_6553 point1, class_6544.class_6553 point2, long offset) {
        return class_3532.method_38652((long)(point1.comp_112() - point2.comp_112())) + class_3532.method_38652((long)(point1.comp_113() - point2.comp_113())) + class_3532.method_38652((long)(point1.comp_114() - point2.comp_114())) + class_3532.method_38652((long)(point1.comp_115() - point2.comp_115())) + class_3532.method_38652((long)(point1.comp_116() - point2.comp_116())) + class_3532.method_38652((long)(point1.comp_117() - point2.comp_117())) + class_3532.method_38652((long)offset);
    }

    public static long getSquaredDistance(class_6544.class_6553 point1, class_6544.class_6553 point2) {
        return BiomeParameterTargets.getSquaredDistance(point1, point2, 0L);
    }

    static {
        CODEC = class_3542.method_28140(BiomeParameterTargets::values);
    }
}

