/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome.sub;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.api.biome.sub.BiomeParameterTargets;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.api.biome.sub.CriterionType;
import com.terraformersmc.biolith.api.biome.sub.RatioTargets;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.biome.sub.BiolithCriteria;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_6497;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public record RatioCriterion(RatioTargets target, class_6497<Float> allowedValues) implements Criterion
{
    public static final MapCodec<RatioCriterion> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RatioTargets.CODEC.fieldOf("target").forGetter(RatioCriterion::target), (App)Codec.FLOAT.optionalFieldOf("min", (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(RatioCriterion::min), (App)Codec.FLOAT.optionalFieldOf("max", (Object)Float.valueOf(Float.POSITIVE_INFINITY)).forGetter(RatioCriterion::max)).apply((Applicative)instance, RatioCriterion::new));

    public RatioCriterion(RatioTargets target, float min, float max) {
        this(target, (class_6497<Float>)new class_6497((Comparable)Float.valueOf(min), (Comparable)Float.valueOf(max)));
    }

    public float min() {
        return ((Float)this.allowedValues.comp_1()).floatValue();
    }

    public float max() {
        return ((Float)this.allowedValues.comp_2()).floatValue();
    }

    @Override
    public CriterionType<? extends Criterion> getType() {
        return BiolithCriteria.RATIO;
    }

    @Override
    public MapCodec<? extends Criterion> getCodec() {
        return CODEC;
    }

    @Override
    public boolean matches(BiolithFittestNodes<class_6880<class_1959>> fittestNodes, DimensionBiomePlacement biomePlacement, class_6544.class_6553 noisePoint, @Nullable class_6497<Float> replacementRange, float replacementNoise) {
        float comparable;
        if (this.target == RatioTargets.CENTER) {
            comparable = class_3532.method_15355((float)BiomeParameterTargets.getSquaredDistance(BiomeParameterTargets.parametersCenterPoint(fittestNodes.ultimate().field_34490), noisePoint, fittestNodes.ultimate().field_34490[6].comp_103())) / 10000.0f;
            if (replacementRange != null) {
                if (((Float)replacementRange.comp_1()).floatValue() <= 0.0f) {
                    if (((Float)replacementRange.comp_2()).floatValue() < 1.0f) {
                        comparable = Math.max(replacementNoise, comparable);
                    }
                } else {
                    comparable = ((Float)replacementRange.comp_2()).floatValue() >= 1.0f ? Math.max(1.0f - replacementNoise, comparable) : Math.max(Math.abs(replacementNoise - (((Float)replacementRange.comp_1()).floatValue() + ((Float)replacementRange.comp_2()).floatValue()) / 2.0f), comparable);
                }
            }
        } else if (this.target == RatioTargets.EDGE) {
            comparable = fittestNodes.penultimate() == null ? 1.0f : (fittestNodes.penultimateDistance() == 0L ? 0.0f : (float)(fittestNodes.penultimateDistance() - fittestNodes.ultimateDistance()) / (float)fittestNodes.penultimateDistance());
            if (replacementRange != null) {
                if (((Float)replacementRange.comp_1()).floatValue() <= 0.0f) {
                    if (((Float)replacementRange.comp_2()).floatValue() < 1.0f) {
                        comparable = Math.min(((Float)replacementRange.comp_2()).floatValue() - replacementNoise, comparable);
                    }
                } else {
                    comparable = ((Float)replacementRange.comp_2()).floatValue() >= 1.0f ? Math.min(replacementNoise - ((Float)replacementRange.comp_1()).floatValue(), comparable) : Math.min(Math.min(replacementNoise - ((Float)replacementRange.comp_1()).floatValue(), ((Float)replacementRange.comp_2()).floatValue() - replacementNoise), comparable);
                }
            }
        } else {
            throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.target));
        }
        return this.allowedValues.method_37955((Comparable)Float.valueOf(comparable));
    }
}

