/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.compat;

import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.compat.TerraBlenderCompat;
import com.terraformersmc.biolith.impl.surface.SurfaceRuleCollector;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_6544;
import net.minecraft.class_6686;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import terrablender.api.Region;
import terrablender.api.SurfaceRuleManager;
import terrablender.worldgen.IExtendedParameterList;

public class TerraBlenderCompatFabric
implements TerraBlenderCompat {
    @Override
    @Nullable
    public BiolithFittestNodes<class_6880<class_1959>> getBiome(int x, int y, int z, class_6544.class_6553 noisePoint, class_6544.class_6547<class_6880<class_1959>> biomeEntries) {
        if (!(biomeEntries instanceof IExtendedParameterList)) {
            return null;
        }
        IExtendedParameterList entries = (IExtendedParameterList)biomeEntries;
        if (!entries.isInitialized()) {
            return null;
        }
        class_6544.class_6548 searchTree = entries.getTree(entries.getUniqueness(x, y, z));
        if (searchTree == null) {
            return null;
        }
        BiolithFittestNodes fittestNodes = searchTree.biolith$searchTreeGet(noisePoint, class_6544.class_6548.class_6550::method_38159);
        if (((class_6880)fittestNodes.ultimate().field_34489).method_40225(Region.DEFERRED_PLACEHOLDER)) {
            searchTree = entries.getTree(0);
            fittestNodes = searchTree.biolith$searchTreeGet(noisePoint, class_6544.class_6548.class_6550::method_38159);
        }
        return fittestNodes;
    }

    @Override
    public void registerSurfaceRules() {
        Map.of(SurfaceRuleCollector.OVERWORLD, SurfaceRuleManager.RuleCategory.OVERWORLD, SurfaceRuleCollector.NETHER, SurfaceRuleManager.RuleCategory.NETHER, SurfaceRuleCollector.END, SurfaceRuleManager.RuleCategory.END).forEach((biolithRules, terrablenderRuleCategory) -> {
            if (biolithRules.getRuleCount() > 0) {
                for (class_2960 ruleOwner : biolithRules.getRuleOwners()) {
                    String namespace = ruleOwner.method_12836();
                    class_6686.class_6708 rule = biolithRules.get(ruleOwner);
                    if (rule == null) continue;
                    if (namespace.equals("minecraft")) {
                        Biolith.LOGGER.warn("Unable to modify surface rules of vanilla biomes via TerraBlender; dropping: {}", (Object)ruleOwner);
                        continue;
                    }
                    try {
                        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)terrablenderRuleCategory, (String)namespace, (class_6686.class_6708)rule);
                    }
                    catch (IllegalArgumentException e) {
                        Biolith.LOGGER.debug("Exception: {}", (Object)e.getMessage());
                        Biolith.LOGGER.warn("Only one surface rule set per namespace can be registered with TerraBlender; dropping: {}", (Object)ruleOwner);
                    }
                }
            }
        });
    }
}

