/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.surface;

import com.google.common.collect.Sets;
import com.terraformersmc.biolith.impl.Biolith;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_6686;
import org.jetbrains.annotations.Nullable;

public class SurfaceRuleCollector {
    public static final SurfaceRuleCollector END = new SurfaceRuleCollector();
    public static final SurfaceRuleCollector NETHER = new SurfaceRuleCollector();
    public static final SurfaceRuleCollector OVERWORLD = new SurfaceRuleCollector();
    private final HashMap<class_2960, List<class_6686.class_6708>> MATERIAL_RULES_DATA = new HashMap(16);
    private final HashMap<class_2960, List<class_6686.class_6708>> MATERIAL_RULES_MODS = new HashMap(16);

    public void addFromData(class_2960 ruleOwner, class_6686.class_6708 ... materialRules) {
        if (materialRules.length > 0) {
            this.MATERIAL_RULES_DATA.computeIfAbsent(ruleOwner, ignored -> new ArrayList(4)).addAll(Arrays.stream(materialRules).toList());
        } else {
            Biolith.LOGGER.warn("Request to add empty surface rule set with ID of '{}'", (Object)ruleOwner);
        }
    }

    public void addFromMods(class_2960 ruleOwner, class_6686.class_6708 ... materialRules) {
        if (materialRules.length > 0) {
            this.MATERIAL_RULES_MODS.computeIfAbsent(ruleOwner, ignored -> new ArrayList(4)).addAll(Arrays.stream(materialRules).toList());
        } else {
            Biolith.LOGGER.warn("Request to add empty surface rule set with ID of '{}'", (Object)ruleOwner);
        }
    }

    public void clearFromData() {
        this.MATERIAL_RULES_DATA.clear();
    }

    public void clearFromMods() {
        this.MATERIAL_RULES_MODS.clear();
    }

    @Nullable
    public class_6686.class_6708 get(class_2960 ruleOwner) {
        if (this.MATERIAL_RULES_DATA.containsKey(ruleOwner)) {
            if (this.MATERIAL_RULES_DATA.get(ruleOwner).size() > 1) {
                class_6686.class_6708[] rules = new class_6686.class_6708[]{};
                return class_6686.method_39050((class_6686.class_6708[])this.MATERIAL_RULES_DATA.get(ruleOwner).toArray(rules));
            }
            return this.MATERIAL_RULES_DATA.get(ruleOwner).get(0);
        }
        if (this.MATERIAL_RULES_MODS.containsKey(ruleOwner)) {
            if (this.MATERIAL_RULES_MODS.get(ruleOwner).size() > 1) {
                class_6686.class_6708[] rules = new class_6686.class_6708[]{};
                return class_6686.method_39050((class_6686.class_6708[])this.MATERIAL_RULES_MODS.get(ruleOwner).toArray(rules));
            }
            return this.MATERIAL_RULES_MODS.get(ruleOwner).get(0);
        }
        return null;
    }

    private class_6686.class_6708 getFromData(class_2960 ruleOwner) {
        if (this.MATERIAL_RULES_DATA.get(ruleOwner).size() > 1) {
            class_6686.class_6708[] rules = new class_6686.class_6708[]{};
            return class_6686.method_39050((class_6686.class_6708[])this.MATERIAL_RULES_DATA.get(ruleOwner).toArray(rules));
        }
        return this.MATERIAL_RULES_DATA.get(ruleOwner).get(0);
    }

    private class_6686.class_6708 getFromMods(class_2960 ruleOwner) {
        if (this.MATERIAL_RULES_MODS.get(ruleOwner).size() > 1) {
            class_6686.class_6708[] rules = new class_6686.class_6708[]{};
            return class_6686.method_39050((class_6686.class_6708[])this.MATERIAL_RULES_MODS.get(ruleOwner).toArray(rules));
        }
        return this.MATERIAL_RULES_MODS.get(ruleOwner).get(0);
    }

    public class_6686.class_6708[] getAll() {
        class_6686.class_6708[] rulesType = new class_6686.class_6708[]{};
        return this.getRuleOwners().stream().map(key -> this.MATERIAL_RULES_DATA.containsKey(key) ? this.getFromData((class_2960)key) : this.getFromMods((class_2960)key)).toList().toArray(rulesType);
    }

    public Set<class_2960> getRuleOwners() {
        return Sets.union(this.MATERIAL_RULES_DATA.keySet(), this.MATERIAL_RULES_MODS.keySet());
    }

    public int getRuleCount() {
        return this.getRuleOwners().size();
    }
}

