/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.EndBiomePlacement;
import com.terraformersmc.biolith.impl.biome.NetherBiomePlacement;
import com.terraformersmc.biolith.impl.biome.OverworldBiomePlacement;
import com.terraformersmc.biolith.impl.compat.BiolithCompat;
import com.terraformersmc.biolith.impl.config.BiolithState;
import com.terraformersmc.biolith.impl.platform.Services;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7134;
import net.minecraft.class_7659;
import net.minecraft.class_7780;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class BiomeCoordinator {
    public static final EndBiomePlacement END = new EndBiomePlacement();
    public static final NetherBiomePlacement NETHER = new NetherBiomePlacement();
    public static final OverworldBiomePlacement OVERWORLD = new OverworldBiomePlacement();
    private static boolean registeredWithTerrablender = false;
    private static BiolithState END_STATE;
    private static BiolithState NETHER_STATE;
    private static BiolithState OVERWORLD_STATE;
    private static boolean serverStarted;
    protected static class_5455.class_6890 registryManager;

    public static boolean isServerStarted() {
        return serverStarted;
    }

    public static void setRegistryManager(class_7780<class_7659> combinedDynamicRegistries) {
        registryManager = combinedDynamicRegistries.method_45926();
    }

    @Nullable
    public static class_5455.class_6890 getRegistryManager() {
        return registryManager;
    }

    public static Optional<class_2378<class_1959>> getBiomeLookup() {
        if (registryManager == null) {
            return Optional.empty();
        }
        return registryManager.method_46759(class_7924.field_41236);
    }

    public static class_7871<class_1959> getBiomeLookupOrThrow() {
        return (class_7871)BiomeCoordinator.getBiomeLookup().orElseThrow();
    }

    public static void handleServerStarting(MinecraftServer server) {
        if (registryManager == null) {
            registryManager = server.method_46221().method_45926();
        }
        if (BiolithCompat.COMPAT_TERRABLENDER && !registeredWithTerrablender) {
            Services.PLATFORM.getTerraBlenderCompat().registerSurfaceRules();
            registeredWithTerrablender = true;
        }
        if (serverStarted) {
            Biolith.LOGGER.warn("Received notification of server start-up but it should already be running!  O.o");
        } else {
            serverStarted = true;
        }
    }

    public static void handleWorldStarting(class_3218 world) {
        Optional dimensionKey = world.method_40134().method_40230();
        if (!serverStarted) {
            Biolith.LOGGER.error("New world '{}' created when server is not running!", (Object)world.method_27983().method_29177());
        }
        if (dimensionKey.isPresent()) {
            if (class_7134.field_37668.equals(dimensionKey.get())) {
                if (END_STATE == null) {
                    END_STATE = (BiolithState)world.method_17983().method_17924(BiolithState.getPersistentStateType("end"));
                    END.serverReplaced(END_STATE, world);
                } else {
                    Biolith.LOGGER.warn("More than one End dimension world created; cowardly ignoring '{}' in favor of '{}'", (Object)world.method_27983().method_29177(), (Object)END_STATE.getWorldId());
                }
            } else if (class_7134.field_37667.equals(dimensionKey.get())) {
                if (NETHER_STATE == null) {
                    NETHER_STATE = (BiolithState)world.method_17983().method_17924(BiolithState.getPersistentStateType("nether"));
                    NETHER.serverReplaced(NETHER_STATE, world);
                } else {
                    Biolith.LOGGER.warn("More than one Nether dimension world created; cowardly ignoring '{}' in favor of '{}'", (Object)world.method_27983().method_29177(), (Object)NETHER_STATE.getWorldId());
                }
            } else if (class_7134.field_37666.equals(dimensionKey.get())) {
                if (OVERWORLD_STATE == null) {
                    OVERWORLD_STATE = (BiolithState)world.method_17983().method_17924(BiolithState.getPersistentStateType("overworld"));
                    OVERWORLD.serverReplaced(OVERWORLD_STATE, world);
                } else {
                    Biolith.LOGGER.warn("More than one Overworld dimension world created; cowardly ignoring '{}' in favor of '{}'", (Object)world.method_27983().method_29177(), (Object)OVERWORLD_STATE.getWorldId());
                }
            } else {
                Biolith.LOGGER.info("Ignoring world '{}'; unknown dimension type: {}", (Object)world.method_27983().method_29177(), (Object)((class_5321)dimensionKey.get()).method_29177());
            }
        } else {
            Biolith.LOGGER.info("Ignoring world '{}'; world has no associated dimension", (Object)world.method_27983().method_29177());
        }
    }

    public static void handleServerStopped(MinecraftServer server) {
        serverStarted = false;
        registryManager = null;
        END_STATE = null;
        NETHER_STATE = null;
        OVERWORLD_STATE = null;
        END.serverStopped();
        NETHER.serverStopped();
        OVERWORLD.serverStopped();
    }

    static {
        serverStarted = false;
    }
}

