/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class BiolithState
extends class_18 {
    private final LinkedHashMap<class_5321<class_1959>, LinkedHashSet<class_5321<class_1959>>> biomeReplacements = new LinkedHashMap(64);
    private final class_3218 world;

    private static <E> Codec<LinkedHashSet<E>> getLinkedHashSetCodec(Codec<E> entryCodec) {
        return entryCodec.listOf().xmap(LinkedHashSet::new, lhs -> lhs.stream().toList());
    }

    public static Codec<BiolithState> getCodec(class_18.class_10740 context) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_5321.method_39154((class_5321)class_7924.field_41236), BiolithState.getLinkedHashSetCodec(class_5321.method_39154((class_5321)class_7924.field_41236))).optionalFieldOf("biome_replacements", Map.of()).forGetter(biolithState -> biolithState.biomeReplacements), (App)BiolithState.getLinkedHashSetCodec(class_5321.method_39154((class_5321)class_7924.field_41236)).listOf().optionalFieldOf("BiomeReplacementsList", List.of()).forGetter(biolithState -> List.of())).apply((Applicative)instance, (replacements, biomeReplacementsList) -> {
            if (!replacements.isEmpty()) {
                return BiolithState.unmarshall_v1(context, replacements);
            }
            if (!biomeReplacementsList.isEmpty()) {
                return BiolithState.unmarshall_v0(context, biomeReplacementsList);
            }
            return new BiolithState(context);
        }));
    }

    public static class_10741<BiolithState> getPersistentStateType(String name) {
        return new class_10741("biolith_" + name + "_state", BiolithState::new, BiolithState::getCodec, null);
    }

    public BiolithState(class_18.class_10740 context) {
        this.world = context.method_67417();
    }

    private static BiolithState unmarshall_v0(class_18.class_10740 context, List<LinkedHashSet<class_5321<class_1959>>> biomeReplacementsList) {
        BiolithState state = new BiolithState(context);
        state.biomeReplacements.clear();
        biomeReplacementsList.forEach(list -> {
            class_5321 key = (class_5321)list.removeFirst();
            state.biomeReplacements.put((class_5321<class_1959>)key, new LinkedHashSet(list));
        });
        state.method_80();
        return state;
    }

    private static BiolithState unmarshall_v1(class_18.class_10740 context, Map<class_5321<class_1959>, LinkedHashSet<class_5321<class_1959>>> replacements) {
        BiolithState state = new BiolithState(context);
        state.biomeReplacements.clear();
        state.biomeReplacements.putAll(replacements);
        return state;
    }

    public void write() {
        this.method_80();
        this.world.method_17983().method_125();
    }

    public Stream<class_5321<class_1959>> getBiomeReplacements(class_5321<class_1959> target) {
        if (this.biomeReplacements.containsKey(target)) {
            return this.biomeReplacements.get(target).stream();
        }
        return Stream.empty();
    }

    public void addBiomeReplacements(class_5321<class_1959> target, Stream<class_5321<class_1959>> replacements) {
        if (this.biomeReplacements.containsKey(target)) {
            replacements.forEachOrdered(this.biomeReplacements.get(target)::add);
        } else {
            this.biomeReplacements.put(target, replacements.collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        this.method_80();
    }

    public class_2960 getDimensionId() {
        if (this.world.method_40134().method_40230().isEmpty()) {
            return class_2960.method_60655((String)"biolith", (String)"unregistered_dimension");
        }
        return ((class_5321)this.world.method_40134().method_40230().get()).method_29177();
    }

    public class_2960 getWorldId() {
        return this.world.method_27983().method_29177();
    }
}

