/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.data.SurfaceGenerationMarshaller;
import com.terraformersmc.biolith.impl.surface.SurfaceRuleCollector;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;

public class SurfaceGenerationLoader
extends class_4080<List<SurfaceGenerationMarshaller>> {
    public static final class_7654 SURFACE_GENERATION_FINDER = class_7654.method_45114((String)"biolith/surface_generation");

    protected List<SurfaceGenerationMarshaller> prepare(class_3300 manager, class_3695 profiler) {
        profiler.method_16065();
        ArrayList<SurfaceGenerationMarshaller> marshallers = new ArrayList<SurfaceGenerationMarshaller>();
        profiler.method_15396("biolith/surface_generation");
        try {
            for (Map.Entry entry : SURFACE_GENERATION_FINDER.method_45113(manager).entrySet()) {
                class_3298 resource = (class_3298)entry.getValue();
                profiler.method_15396(resource.method_14480());
                try {
                    InputStream inputStream = resource.method_14482();
                    try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                        profiler.method_15396("parse");
                        JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        SurfaceGenerationMarshaller marshaller = SurfaceGenerationLoader.get(SurfaceGenerationMarshaller.CODEC, (JsonElement)jsonObject);
                        if (marshaller == null) {
                            throw new RuntimeException();
                        }
                        marshallers.add(marshaller);
                        profiler.method_15407();
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable closeBreak) {
                                throwable.addSuppressed(closeBreak);
                            }
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                catch (RuntimeException runtimeBreak) {
                    Biolith.LOGGER.warn("Parsing error loading surface generation '{}': '{}'", (Object)resource.method_14480(), (Object)runtimeBreak);
                }
                profiler.method_15407();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        profiler.method_15407();
        profiler.method_16066();
        return marshallers;
    }

    protected void apply(List<SurfaceGenerationMarshaller> marshallers, class_3300 manager, class_3695 profiler) {
        if (BiomeCoordinator.isServerStarted()) {
            Biolith.LOGGER.warn("Ignoring request to reload surface generation data while server is running.");
            return;
        }
        if (!marshallers.isEmpty()) {
            Biolith.LOGGER.info("Applying surface generation data from {} source(s).", (Object)marshallers.size());
        }
        SurfaceRuleCollector.OVERWORLD.clearFromData();
        SurfaceRuleCollector.NETHER.clearFromData();
        SurfaceRuleCollector.END.clearFromData();
        for (SurfaceGenerationMarshaller marshaller : marshallers) {
            marshaller.unmarshall();
        }
    }

    public static <R> R get(Decoder<R> decoder, JsonElement jsonElement) throws NullPointerException {
        return (R)decoder.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).result().orElseThrow();
    }
}

