/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.api.biome;

import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;

public final class BiomePlacement {
    private BiomePlacement() {
        throw new UnsupportedOperationException();
    }

    public static void addEnd(ResourceKey<Biome> biome, Climate.ParameterPoint noisePoint) {
        BiomeCoordinator.END.addPlacement(biome, noisePoint, false);
    }

    public static void addNether(ResourceKey<Biome> biome, Climate.ParameterPoint noisePoint) {
        BiomeCoordinator.NETHER.addPlacement(biome, noisePoint, false);
    }

    public static void addOverworld(ResourceKey<Biome> biome, Climate.ParameterPoint noisePoint) {
        BiomeCoordinator.OVERWORLD.addPlacement(biome, noisePoint, false);
    }

    public static void removeEnd(ResourceKey<Biome> biome) {
        BiomeCoordinator.END.addRemoval(biome, false);
    }

    public static void removeNether(ResourceKey<Biome> biome) {
        BiomeCoordinator.NETHER.addRemoval(biome, false);
    }

    public static void removeOverworld(ResourceKey<Biome> biome) {
        BiomeCoordinator.OVERWORLD.addRemoval(biome, false);
    }

    public static void replaceEnd(ResourceKey<Biome> target, ResourceKey<Biome> biome) {
        BiomeCoordinator.END.addReplacement(target, biome, 1.0, false);
    }

    public static void replaceEnd(ResourceKey<Biome> target, ResourceKey<Biome> biome, double proportion) {
        BiomeCoordinator.END.addReplacement(target, biome, proportion, false);
    }

    public static void replaceNether(ResourceKey<Biome> target, ResourceKey<Biome> biome) {
        BiomeCoordinator.NETHER.addReplacement(target, biome, 1.0, false);
    }

    public static void replaceNether(ResourceKey<Biome> target, ResourceKey<Biome> biome, double proportion) {
        BiomeCoordinator.NETHER.addReplacement(target, biome, proportion, false);
    }

    public static void replaceOverworld(ResourceKey<Biome> target, ResourceKey<Biome> biome) {
        BiomeCoordinator.OVERWORLD.addReplacement(target, biome, 1.0, false);
    }

    public static void replaceOverworld(ResourceKey<Biome> target, ResourceKey<Biome> biome, double proportion) {
        BiomeCoordinator.OVERWORLD.addReplacement(target, biome, proportion, false);
    }

    public static void addSubEnd(ResourceKey<Biome> target, ResourceKey<Biome> biome, Criterion criterion) {
        BiomeCoordinator.END.addSubBiome(target, biome, criterion, false);
    }

    public static void addSubNether(ResourceKey<Biome> target, ResourceKey<Biome> biome, Criterion criterion) {
        BiomeCoordinator.NETHER.addSubBiome(target, biome, criterion, false);
    }

    public static void addSubOverworld(ResourceKey<Biome> target, ResourceKey<Biome> biome, Criterion criterion) {
        BiomeCoordinator.OVERWORLD.addSubBiome(target, biome, criterion, false);
    }
}

