/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.api.biome.sub;

import com.mojang.serialization.Codec;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import net.minecraft.core.QuartPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.biome.Climate;

public enum BiomeParameterTargets implements StringRepresentable
{
    TEMPERATURE("temperature"),
    HUMIDITY("humidity"),
    CONTINENTALNESS("continentalness"),
    EROSION("erosion"),
    DEPTH("depth"),
    WEIRDNESS("weirdness"),
    PEAKS_VALLEYS("peaks_valleys"),
    DEPTH_OCEAN("depth_ocean");

    public static final Codec<BiomeParameterTargets> CODEC;
    private final String name;

    private BiomeParameterTargets(String name) {
        this.name = name;
    }

    public long getNoiseValue(Climate.TargetPoint noisePoint) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> noisePoint.temperature();
            case 1 -> noisePoint.humidity();
            case 2 -> noisePoint.continentalness();
            case 3 -> noisePoint.erosion();
            case 4 -> noisePoint.depth();
            case 5 -> noisePoint.weirdness();
            case 6 -> BiomeParameterTargets.getPeaksValleysNoiseLong(noisePoint.weirdness());
            case 7 -> BiomeParameterTargets.getDepthWithOceanSurfaceLong(noisePoint.depth());
        };
    }

    public String getSerializedName() {
        return this.name;
    }

    public static long getPeaksValleysNoiseLong(long weirdness) {
        return 10000L - Math.abs(Math.abs(weirdness * 3L) - 20000L);
    }

    public static long getDepthWithOceanSurfaceLong(long depth) {
        ServerLevel world = DimensionBiomePlacement.getEvaluatingWorld();
        int seaLevel = world.getSeaLevel();
        double bottom = world.getMinY();
        double top = world.getMaxY();
        double bottomNew = 15000.0;
        double topNew = -15000.0;
        return Math.max(depth, (long)Mth.clampedMap((double)QuartPos.toBlock((int)DimensionBiomePlacement.getEvaluatingBiomePos().getY()), (double)bottom, (double)top, (double)bottomNew, (double)topNew) - (long)Mth.clampedMap((double)seaLevel, (double)bottom, (double)top, (double)bottomNew, (double)topNew));
    }

    public static long parameterCenter(Climate.Parameter range) {
        return (range.min() + range.max()) / 2L;
    }

    public static Climate.TargetPoint parametersCenterPoint(Climate.Parameter[] parameters) {
        return new Climate.TargetPoint(BiomeParameterTargets.parameterCenter(parameters[0]), BiomeParameterTargets.parameterCenter(parameters[1]), BiomeParameterTargets.parameterCenter(parameters[2]), BiomeParameterTargets.parameterCenter(parameters[3]), BiomeParameterTargets.parameterCenter(parameters[4]), BiomeParameterTargets.parameterCenter(parameters[5]));
    }

    public static long getSquaredDistance(Climate.TargetPoint point1, Climate.TargetPoint point2, long offset) {
        return Mth.square((long)(point1.temperature() - point2.temperature())) + Mth.square((long)(point1.humidity() - point2.humidity())) + Mth.square((long)(point1.continentalness() - point2.continentalness())) + Mth.square((long)(point1.erosion() - point2.erosion())) + Mth.square((long)(point1.depth() - point2.depth())) + Mth.square((long)(point1.weirdness() - point2.weirdness())) + Mth.square((long)offset);
    }

    public static long getSquaredDistance(Climate.TargetPoint point1, Climate.TargetPoint point2) {
        return BiomeParameterTargets.getSquaredDistance(point1, point2, 0L);
    }

    static {
        CODEC = StringRepresentable.fromEnum(BiomeParameterTargets::values);
    }
}

